% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncbi_snp_summary.R
\name{ncbi_snp_summary}
\alias{ncbi_snp_summary}
\title{Query NCBI's dbSNP for summary information on a set of SNPs}
\usage{
ncbi_snp_summary(x, key = NULL, ...)
}
\arguments{
\item{x}{A vector of SNPs (with or without 'rs' prefix)}

\item{key}{(character) NCBI Entrez API key. optional.
See "NCBI Authenication" in \link{rsnps-package}}

\item{...}{Curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Query NCBI's dbSNP for summary information on a set of SNPs
}
\examples{
\dontrun{
# use with 'rs' or without it
ncbi_snp_summary("rs420358")
ncbi_snp_summary("420358")

# you can pass > 1
x <- c("rs332", "rs420358", "rs1837253", "rs1209415715", "rs111068718")
ncbi_snp_summary(x)

ncbi_snp_summary("rs420358")
ncbi_snp_summary("rs332") # warning, merged into new one
ncbi_snp_summary("rs121909001") 
ncbi_snp_summary("rs1837253")
ncbi_snp_summary("rs1209415715") # no data available
ncbi_snp_summary("rs111068718") # chromosomal information may be unmapped
}
}
\seealso{
\code{\link[=ncbi_snp_query2]{ncbi_snp_query2()}}
}
