testthat::context("is.simsum")

testthat::test_that("is.simsum works as expected", {
  data("MIsim", package = "rsimsum")
  x <- rsimsum::simsum(data = MIsim, estvarname = "b", true = 0.5, se = "se", methodvar = "method")
  testthat::expect_true(object = is.simsum(x))
  testthat::expect_false(object = is.summary.simsum(x))
  testthat::expect_false(object = is.simsum(MIsim))
  testthat::expect_false(object = is.multisimsum(x))
})
testthat::test_that("is.summary.simsum works as expected", {
  data("MIsim", package = "rsimsum")
  x <- rsimsum::simsum(data = MIsim, estvarname = "b", true = 0.5, se = "se", methodvar = "method")
  sx <- summary(x)
  testthat::expect_true(object = is.summary.simsum(sx))
  testthat::expect_false(object = is.simsum(sx))
  testthat::expect_false(object = is.multisimsum(sx))
  testthat::expect_false(object = is.summary.multisimsum(sx))
})

testthat::context("is.multisimsum")
testthat::test_that("is.multisimsum works as expected", {
  data("frailty", package = "rsimsum")
  x <- rsimsum::multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se", methodvar = "model", by = "fv_dist")
  testthat::expect_true(object = is.multisimsum(x))
  testthat::expect_false(object = is.multisimsum(frailty))
  testthat::expect_false(object = is.simsum(x))
})
testthat::test_that("is.summary.multisimsum works as expected", {
  data("frailty", package = "rsimsum")
  x <- rsimsum::multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se", methodvar = "model", by = "fv_dist")
  sx <- summary(x)
  testthat::expect_true(object = is.summary.multisimsum(sx))
  testthat::expect_false(object = is.simsum(sx))
  testthat::expect_false(object = is.multisimsum(sx))
  testthat::expect_false(object = is.summary.simsum(sx))
})
