% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lolly.multisimsum.R
\name{lolly.multisimsum}
\alias{lolly.multisimsum}
\title{lolly method for multisimsum objects}
\usage{
\method{lolly}{multisimsum}(obj, sstat, par = NULL, by = NULL,
  target = NULL, level = 0.95, gpars = list(), ...)
}
\arguments{
\item{obj}{An object of class \code{multisimsum}.}

\item{sstat}{Summary statistic to plot. Possible choices are: \code{nsim}, number of replications without missing estimates / standard errors; \code{thetamean}, average estimated value; \code{thetamedian}, median estimated value; \code{se2mean}, average estimated standard error; \code{se2median}, median estimated standard error; \code{bias}, bias in point estimate; \code{empse}, empirical standard error; \code{mse}, mean squared error; \code{relprec}, percentage gain in precision relative to the reference method; \code{modelse}, model-based standard error; \code{relerror}, relative percentage error in standard error; \code{cover}, coverage of nominal \eqn{(1 - \alpha)}\% CI; \code{bccover}, bias corrected coverage of nominal \eqn{(1 - \alpha)}\% CI; \code{power}, power of \eqn{\alpha}\% level test.}

\item{par}{Estimand to plot. Defaults to \code{NULL}, in which case the \code{par} variable from \code{multisimsum} will be used for faceting.}

\item{by}{Faceting factors passed to \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}. Defaults to \code{NULL}, i.e. no faceting.}

\item{target}{Target value for the summary statistic of interest. If \code{NULL} (the default), the target value is inferred (except for \code{sstat = nsim}).}

\item{level}{Specifies the confidence level for confidence intervals based on Monte Carlo standard errors, produced by default if the \code{simsum} or \code{summary.simsum} object passed to \code{lolly} estimated Monte Carlo standard errors (e.g. with \code{mcse = TRUE}).}

\item{gpars}{Graphical parameters. Must be a named list, with possible parameters:
\itemize{
\item \code{target.shape}, shape of the vertical line at \code{target} value;
\item \code{target.colour}, colour of the vertical line at \code{target} value;
\item \code{segment.shape}, shape of the horizontal segment between \code{target} and estimated value;
\item \code{segment.colour}, colour of the horizontal segment between \code{target} and estimated value;
\item \code{low.end}, shape of the lower end of the confidence interval;
\item \code{upp.end}, shape of the upper end of the confidence interval.
It is possible to redefine all the graphical parameters of a subset only; if not specified, sensible default values will be utilised.
}}

\item{...}{Ignored.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object that can be combined with additional \code{geom_*}, \code{scale_*}, \code{theme_*}, etc.
}
\description{
\code{\link[=lolly]{lolly()}} method for objects of class \code{multisimsum}.
}
\details{
Coverage, bias corrected coverage, and power will be based on the \eqn{\alpha} defined in the call to \code{simsum}.
}
\examples{
library(rsimsum)
library(ggplot2)
data("frailty", package = "rsimsum")
ms <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50,
   fv = 0.75), estvarname = "b", se = "se", methodvar = "model",
   by = "fv_dist")
lolly(ms, sstat = "bias", par = "trt", by = "fv_dist")
}
