#' DCA-ordinated pollen data from Lake Consuelo with RSI values
#'
#' A dataset containing pre-processed DCA-ordinated data from 
#' Bush, Silman & Urrego (2004) <doi:10.1126/science.1090795>.
#' This data has been processed using Rodionov(lake_data, "DCA1", "Age", l=5, merge=TRUE)
#'
#' \itemize{
#'   \item DCA1 - DCA values for each timepoint from the raw dataset.
#'   \item Age - timepoint of each sample that has been DCA-ordinated.
#'   \item RSI - Regime Shift Index (see docs for Rodionov()) for each timepoint.
#' }
#'
#' @docType data
#' @keywords datasets
#' @name lake_RSI
#' @usage data(lake_RSI)
#' @format A data frame with 39 rows and 3 variables
NULL
