% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{geom_point}
\alias{geom_point}
\alias{geom_multipoint}
\alias{geom_linestring}
\alias{geom_polygon}
\title{Construct Geometries}
\usage{
geom_point(x, y)

geom_multipoint(x, y, id = 1)

geom_linestring(x, y, id = 1)

geom_polygon(x, y, id = 1, ring = 1)
}
\arguments{
\item{x}{a vector of x coordinates}

\item{y}{a vector of y coordinates}

\item{id}{the feature identifier}

\item{ring}{the id of the polygon ring}
}
\value{
an object of class \code{rsgeo}
}
\description{
Constructs geometries from numeric vectors.
}
\examples{
geom_point(3, 0.14)
geom_multipoint(1:10, 10:1)
geom_linestring(1:10, 10:1)
geom_polygon(c(0, 1, 1, 0, 0), c(0, 0, 1, 1, 0))
}
