% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scopus_search.R
\name{scopus_search}
\alias{scopus_search}
\title{SCOPUS Search}
\usage{
scopus_search(query, api_key = NULL, count = 200, view = c("STANDARD",
  "COMPLETE"), start = 0, verbose = TRUE, max_count = 20000,
  http = "https://api.elsevier.com/content/search/scopus", ...)
}
\arguments{
\item{query}{Query string to search on SCOPUS}

\item{api_key}{API Key for Elsevier}

\item{count}{number of records to retrieve (below 200 for STANDARD,
below 25 for COMPLETE views, see
\url{https://dev.elsevier.com/api_key_settings.html})}

\item{view}{type of view to give, see
\url{https://api.elsevier.com/documentation/ScopusSearchAPI.wadl}}

\item{start}{where should the records start gathering}

\item{verbose}{Print diagnostic messages}

\item{max_count}{Maximum count of records to be returned.}

\item{http}{Address for scopus API}

\item{...}{Arguments to be passed to the query list for
\code{\link{GET}}}
}
\value{
List of entries from SCOPUS
}
\description{
This function wraps \code{\link{generic_elsevier_api}} to give a
scopus search from the Elsevier Scopus Search API

Searches SCOPUS to get information about documents on an author.
}
\examples{
\dontrun{
res = scopus_search(query = "all(gene)", max_count = 200)
df = gen_entries_to_df(res$entries)
}
}
