% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specVar.R
\name{specVar}
\alias{specVar}
\title{specVar}
\usage{
specVar(img = img, xy = NULL, pxr = pxr)
}
\arguments{
\item{img}{Object of class \emph{RasterLayer}.}

\item{xy}{Object of class \emph{SpatialPoints} or \emph{SpatialPointsDataFrame}.}

\item{pxr}{vector of target resolutions.}
}
\value{
A \emph{list}.
}
\description{
Quantifies how changes in the resolution of a raster affects the perception of spectral complexity.
}
\details{
{Given a raster object, the function determines how reducing the resolution
of the raster impacts our ability to perceive the complexity of the landscape. The
function aggregates \emph{img} to each of the given pixel resolutions (\emph{pxr})
and estimates the Mean Absolute Error (MAE) for each pixel with the aggregated
layer where the differences are estimated from the pixel within the original raster
that overlap with the target pixel. If a point shapefile is provided (\emph{xy}),
the function will only report on the values that overlap with the points. The output
of the function consists of:
\itemize{
 \item{\emph{mae} - MAE, either for all pixels or for the points within \emph{xy}}
 \item{\emph{pixel.optimal} - raster reporting on the resolution with the lowest MAE for each pixel}
 \item{\emph{pixel.optimal.stats} - Proportion of samples per resolution derived from \emph{pixel.optimal}}
 \item{\emph{plot} - boxplots of the variability of the MAE per resolution}}
If \emph{xy} is set, the output will contain a vector with the optimal resolution per sample (\emph{$sample.optimal}).}
}
\examples{
\dontrun{

 require(raster)

 # read raster data
 r <- raster(system.file('extdata', 'tcb_1.tif', package="rsMove"))

 # read movement data
 moveData <- read.csv(system.file('extdata', 'konstanz_20130804.csv', package="rsMove"))
 moveData <- SpatialPointsDataFrame(moveData[,1:2], moveData, proj4string=crs(r))

 # apply function
 s.var <- specVar(img=r, xy=moveData, pxr=60)

}
}
\seealso{
\code{\link{tMoveRes}} \code{\link{sMoveRes}}
}
