% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rrr.R
\name{cv.rrr}
\alias{cv.rrr}
\title{Reduced-rank regression with rank selected by cross validation}
\usage{
cv.rrr(Y, X, nfold = 10, maxrank = min(dim(Y), dim(X)),
       norder = NULL, coefSVD = FALSE)
}
\arguments{
\item{Y}{response matrix}

\item{X}{covariate matrix}

\item{nfold}{number of folds}

\item{maxrank}{maximum rank allowed}

\item{norder}{for constructing the folds}

\item{coefSVD}{If TRUE, svd of the coefficient is retuned}
}
\value{
a list containing rr estimates from cross validation
}
\description{
Reduced-rank regression with rank selected by cross validation
}
\examples{
library(rrpack)
p <- 50; q <- 50; n <- 100; nrank <- 3
mydata <- rrr.sim1(n, p, q, nrank, s2n = 1, sigma = NULL,
                   rho_X = 0.5, rho_E = 0.3)
rfit_cv <- with(mydata, cv.rrr(Y, X, nfold = 10, maxrank = 10))
summary(rfit_cv)
coef(rfit_cv)
}
\references{
Chen, K., Dong, H. and Chan, K.-S. (2013) Reduced rank regression via
adaptive nuclear norm penalization. \emph{Biometrika}, 100, 901--920.
}
