% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_threats.R
\name{rl_use_and_trade}
\alias{rl_use_and_trade}
\alias{rl_use_and_trade_}
\title{Use and trade assessment summary}
\usage{
rl_use_and_trade(
  code = NULL,
  key = NULL,
  parse = TRUE,
  all = TRUE,
  page = 1,
  quiet = FALSE,
  ...
)

rl_use_and_trade_(
  code = NULL,
  key = NULL,
  all = TRUE,
  page = 1,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{code}{(character) The code of the use and trade to look up. If not
supplied, a list of all uses and trades will be returned.}

\item{key}{(character) An IUCN API token. See \code{\link[=rl_use_iucn]{rl_use_iucn()}}.}

\item{parse}{(logical) Whether to parse the output to list (\code{FALSE}) or,
where possible, data.frame (\code{TRUE}). Default: \code{TRUE}.}

\item{all}{(logical) Whether to retrieve all results at once or not. If
\code{TRUE} we do the paging internally for you and bind all of the results
together. If \code{FALSE}, only a single page of results will be retrieved.}

\item{page}{(integer/numeric) Page to get if \code{all} is \code{FALSE}. Default: 1.
Each page returns up to 100 records. Paging is required because it's too
much burden on a server to just "get all the data" in one request.}

\item{quiet}{(logical) Whether to suppress progress for multi-page downloads
or not. Default: \code{FALSE} (that is, give progress). Ignored if \code{all = FALSE}.}

\item{...}{Includes the following filters that are supported by the API
endpoint (refer to the \href{https://api.iucnredlist.org/api-docs/index.html}{API docs} for more
information):
\itemize{
\item \code{year_published}: (integer) Set this to return only
assessments from a given year.
\item \code{latest}: (logical) Set this to \code{TRUE} to return only the
latest assessment for each taxon.
\item \code{scope_code}: (integer) Set this to return only assessments
from a particular \link[=rl_scopes]{scope} (e.g., \code{1} for Global, \code{2} for
Europe). This is similar to the \code{region} argument of the old Red List
API and old versions of rredlist.
}
Also includes the following arguments related to the wait time between
request retries if a "Too Many Requests" error is received from the API
(see \link[crul:HttpClient]{HttpClient()$retry()} for more details):
\itemize{
\item \code{pause_base}, \code{pause_cap}, and \code{pause_min}: basis, maximum, and minimum
for calculating wait time for retry
\item \code{times}: the maximum number of times to retry
\item \code{onwait}: a callback function if the request will be retried and a
wait time is being applied
}
Also supports any \link[curl:curl_options]{curl options} passed to the GET
request via \link[crul:HttpClient]{HttpClient}.}
}
\value{
A list unless using a function with a trailing underscore, in which
case json as character string is returned.
}
\description{
Return a list of the latest assessments which are subject to a specific use
and trade.
}
\examples{
\dontrun{
# Get all stresses
rl_use_and_trade()
# Get assessment summary for medicinal use and trade
rl_use_and_trade("3")
}
}
\references{
API docs at \url{https://api.iucnredlist.org/}.
}
\seealso{
Assessments by threat details:
\code{\link{rl_categories}()},
\code{\link{rl_pop_trends}()},
\code{\link{rl_stresses}()},
\code{\link{rl_threats}()}
}
\concept{threats}
