/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import org.apache.jena.iri.IRI;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.checker.CheckerIRI;
import org.apache.jena.riot.checker.CheckerLiterals;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ParserProfileBase;
import org.apache.jena.riot.system.Prologue;
import org.apache.jena.riot.system.RiotLib;

public class ParserProfileChecker
extends ParserProfileBase {
    private boolean checkLiterals = true;
    private boolean resolveURIs = true;

    public ParserProfileChecker(Prologue prologue, ErrorHandler errorHandler) {
        super(prologue, errorHandler);
    }

    public ParserProfileChecker(Prologue prologue, ErrorHandler errorHandler, LabelToNode labelMapping) {
        super(prologue, errorHandler, labelMapping);
    }

    @Override
    public String resolveIRI(String uriStr, long line, long col) {
        return this.makeIRI(uriStr, line, col).toString();
    }

    @Override
    public IRI makeIRI(String uriStr, long line, long col) {
        IRI iri2 = this.prologue.getResolver().resolveSilent(uriStr);
        CheckerIRI.iriViolations(iri2, this.errorHandler, line, col);
        return iri2;
    }

    @Override
    public Triple createTriple(Node subject, Node predicate, Node object, long line, long col) {
        this.checkTriple(subject, predicate, object, line, col);
        return super.createTriple(subject, predicate, object, line, col);
    }

    private void checkTriple(Node subject, Node predicate, Node object, long line, long col) {
        if (subject == null || !subject.isURI() && !subject.isBlank()) {
            this.errorHandler.error("Subject is not a URI or blank node", line, col);
            throw new RiotException("Bad subject: " + subject);
        }
        if (predicate == null || !predicate.isURI()) {
            this.errorHandler.error("Predicate not a URI", line, col);
            throw new RiotException("Bad predicate: " + predicate);
        }
        if (object == null || !object.isURI() && !object.isBlank() && !object.isLiteral()) {
            this.errorHandler.error("Object is not a URI, blank node or literal", line, col);
            throw new RiotException("Bad object: " + object);
        }
    }

    @Override
    public Quad createQuad(Node graph, Node subject, Node predicate, Node object, long line, long col) {
        this.checkQuad(graph, subject, predicate, object, line, col);
        return super.createQuad(graph, subject, predicate, object, line, col);
    }

    private void checkQuad(Node graph, Node subject, Node predicate, Node object, long line, long col) {
        if (graph != null && !graph.isURI()) {
            this.errorHandler.error("Graph name is not a URI", line, col);
            throw new RiotException("Bad graph name: " + graph);
        }
        this.checkTriple(subject, predicate, object, line, col);
    }

    @Override
    public Node createURI(String x, long line, long col) {
        if (RiotLib.isBNodeIRI(x)) {
            return RiotLib.createIRIorBNode(x);
        }
        String resolvedIRI = this.resolveIRI(x, line, col);
        return NodeFactory.createURI((String)resolvedIRI);
    }

    @Override
    public Node createTypedLiteral(String lexical, RDFDatatype datatype, long line, long col) {
        Node n = NodeFactory.createLiteral((String)lexical, null, (RDFDatatype)datatype);
        CheckerLiterals.checkLiteral(lexical, datatype, this.errorHandler, line, col);
        return n;
    }

    @Override
    public Node createLangLiteral(String lexical, String langTag, long line, long col) {
        Node n = NodeFactory.createLiteral((String)lexical, (String)langTag, null);
        CheckerLiterals.checkLiteral(lexical, langTag, this.errorHandler, line, col);
        return n;
    }

    @Override
    public Node createPlainLiteral(String lexical, long line, long col) {
        return NodeFactory.createLiteral((String)lexical);
    }

    @Override
    public Node createBlankNode(Node scope, String label, long line, long col) {
        return (Node)this.labelMapping.get(scope, label);
    }
}

