/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.modify.GraphStoreAction;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateException;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphStoreUtils {
    public static void sendToAll(GraphStore graphStore, final Object object) {
        GraphStoreUtils.actionAll(graphStore, new GraphStoreAction(){

            public void exec(Graph graph) {
                graph.getEventManager().notifyEvent(graph, object);
            }
        });
    }

    public static void actionAll(GraphStore graphStore, GraphStoreAction action) {
        action.exec(graphStore.getDefaultGraph());
        Iterator<Node> iter = graphStore.listGraphNodes();
        while (iter.hasNext()) {
            Node gn = iter.next();
            Graph g = graphStore.getGraph(gn);
            if (g == null) {
                throw new UpdateException("No such graph: " + gn);
            }
            action.exec(g);
        }
    }

    public static void action(GraphStore graphStore, Node graphName, GraphStoreAction action) {
        Graph g = null;
        if (graphName != null) {
            g = graphStore.getGraph(graphName);
            if (g == null) {
                throw new UpdateException("No such graph: " + graphName);
            }
        } else {
            g = graphStore.getDefaultGraph();
        }
        action.exec(g);
    }

    public static void action(GraphStore graphStore, List<Node> graphNodes, GraphStoreAction action) {
        if (graphNodes.isEmpty()) {
            Graph g = graphStore.getDefaultGraph();
            action.exec(g);
        } else {
            for (Node gn : graphNodes) {
                Graph g = graphStore.getGraph(gn);
                if (g == null) {
                    throw new UpdateException("No such graph: " + gn);
                }
                action.exec(g);
            }
        }
    }
}

