/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.path;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.lang.arq.ARQParser;
import com.hp.hpl.jena.sparql.lang.arq.ParseException;
import com.hp.hpl.jena.sparql.lang.arq.TokenMgrError;
import com.hp.hpl.jena.sparql.path.Path;
import java.io.StringReader;
import org.openjena.atlas.logging.Log;

public class PathParser {
    public static Path parse(String str2, PrefixMapping pmap) {
        return PathParser.parse(str2, new Prologue(pmap));
    }

    public static Path parse(String str2, Prologue prologue) {
        Query query2 = new Query(prologue);
        StringReader in = new StringReader(str2);
        ARQParser parser = new ARQParser(in);
        try {
            query2.setStrict(true);
            parser.setQuery(query2);
            return parser.PathUnit();
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError tErr) {
            int col = parser.token.endColumn;
            int line = parser.token.endLine;
            throw new QueryParseException(tErr.getMessage(), line, col);
        }
        catch (QueryException ex) {
            throw ex;
        }
        catch (JenaException ex) {
            throw new QueryException(ex.getMessage(), ex);
        }
        catch (Error err) {
            throw new QueryParseException(err.getMessage(), err, -1, -1);
        }
        catch (Throwable th) {
            Log.warn(PathParser.class, "Unexpected throwable: ", th);
            throw new QueryException(th.getMessage(), th);
        }
    }
}

