% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_controller.R
\name{build_join_plan}
\alias{build_join_plan}
\title{Build a join plan}
\usage{
build_join_plan(tDesc, ..., check = TRUE)
}
\arguments{
\item{tDesc}{description of tables from \code{\link{describe_tables}} (and likely altered by user). Note: no column names must intersect with names of the form \code{table_CLEANEDTABNAME_present}.}

\item{...}{force later arguments to bind by name.}

\item{check}{logical, if TRUE check the join plan for consistnecy.}
}
\value{
detailed column join plan (appropriate for editing)
}
\description{
Please see \code{vignette('DependencySorting', package = 'rquery')} and \code{vignette('joinController', package= 'rquery')} for more details.
}
\examples{

if (requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  d <- data.frame(id=1:3, weight= c(200, 140, 98))
  DBI::dbWriteTable(my_db,"d1", d)
  DBI::dbWriteTable(my_db,"d2", d)
  tDesc <- describe_tables(my_db, c("d1", "d2"))
  tDesc$keys[[1]] <- list(PrimaryKey= 'id')
  tDesc$keys[[2]] <- list(PrimaryKey= 'id')
  print(build_join_plan(tDesc))
  DBI::dbDisconnect(my_db)
}

}
\seealso{
\code{\link{describe_tables}}, \code{\link{inspect_join_plan}}, \code{\link{graph_join_plan}}, \code{\link{actualize_join_plan}}
}
