% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsummary.R
\name{rsummary_node}
\alias{rsummary_node}
\title{Create an rsumary relop operator node.}
\usage{
rsummary_node(source, ..., incoming_table_name = mk_tmp_name_source("rin")(),
  outgoing_table_name = mk_tmp_name_source("rout")(), overwrite = TRUE,
  temporary = TRUE)
}
\arguments{
\item{source}{incoming source (relop node or data.frame).}

\item{...}{force later arguments to be by name}

\item{incoming_table_name}{character, name of incoming table.}

\item{outgoing_table_name}{character, name of table to write.}

\item{overwrite}{logical, if TRUE overwrite tables}

\item{temporary}{logical, if TRUE use temporary tables}
}
\value{
rsummary node
}
\description{
Create an rsumary relop operator node.
}
\examples{

 d <- data.frame(p= c(TRUE, FALSE, NA),
                 s= NA,
                 w= 1:3,
                 x= c(NA,2,3),
                 y= factor(c(3,5,NA)),
                 z= c('a',NA,'a'),
                 stringsAsFactors=FALSE)
 db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
 RSQLite::initExtension(db)
 DBI::dbWriteTable(db, "dRemote", d,
                   overwrite = TRUE,
                   temporary = TRUE)

 ops <- dbi_table(db, "dRemote") \%.>\%
   extend_nse(., v := ifelse(x>2, "x", "y")) \%.>\%
   rsummary_node(.)
 cat(format(ops))

 to_sql(ops, db)

 reshdl <- materialize(db, ops)
 DBI::dbGetQuery(db, to_sql(reshdl, db))

 DBI::dbDisconnect(db)

}
\seealso{
\code{\link{non_sql_node}}
}
