% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_db_wrapper_fns.R
\name{dbAsDate}
\alias{dbAsDate}
\title{Converts to timestamp.}
\usage{
dbAsDate(conn, name, date = "date", tz = NULL, display = TRUE,
  exec = TRUE)
}
\arguments{
\item{conn}{A connection object.}

\item{name}{A character string specifying a PostgreSQL table name.}

\item{date}{A character string specifying the date field.}

\item{tz}{A character string specifying the time zone, in
\code{"EST"}, \code{"America/New_York"}, \code{"EST5EDT"},
\code{"-5"}.}

\item{display}{Logical. Whether to display the query (defaults to
\code{TRUE}).}

\item{exec}{Logical. Whether to execute the query (defaults to
\code{TRUE}).}
}
\value{
If \code{exec = TRUE}, returns \code{TRUE} if the
    conversion was successful.
}
\description{
Convert a date field to a timestamp with or without time zone.
}
\examples{
## Example uses a dummy connection from DBI package
conn <- DBI::ANSI()
dbAsDate(conn, name = c("schema", "table"), date = "date", tz = "GMT",
    exec = FALSE)
}
\seealso{
The PostgreSQL documentation:
    \url{http://www.postgresql.org/docs/current/static/datatype-datetime.html}
}
\author{
Mathieu Basille \email{basille@ufl.edu}
}
