% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_phylopic_base.r
\name{add_phylopic_base}
\alias{add_phylopic_base}
\title{Add a PhyloPic to a base R plot}
\usage{
add_phylopic_base(
  img = NULL,
  name = NULL,
  uuid = NULL,
  x = NULL,
  y = NULL,
  ysize = NULL,
  alpha = 1,
  color = "black"
)
}
\arguments{
\item{img}{A Picture or png array object, e.g., from using
\code{\link[=get_phylopic]{get_phylopic()}}.}

\item{name}{A taxonomic name to be passed to \code{\link[=get_uuid]{get_uuid()}}.}

\item{uuid}{A valid uuid for a PhyloPic silhouette (such as that returned
by \code{\link[=get_uuid]{get_uuid()}} or \code{\link[=pick_phylopic]{pick_phylopic()}}).}

\item{x}{x value of the silhouette center. Ignored if \code{y} and \code{ysize} are
not specified.}

\item{y}{y value of the silhouette center. Ignored if \code{x} and \code{ysize} are
not specified.}

\item{ysize}{Height of the silhouette. The width is determined by the
aspect ratio of the original image. Ignored if \code{x} and \code{y} are not
specified.}

\item{alpha}{A value between 0 and 1, specifying the opacity of the
silhouette.}

\item{color}{Color to plot the silhouette in.}
}
\description{
Specify an existing image, taxonomic name, or PhyloPic uuid to add a
PhyloPic silhouette on top of an existing base R plot.
}
\details{
One (and only one) of \code{img}, \code{name}, or \code{uuid} must be specified.
Use parameters \code{x}, \code{y}, and \code{ysize} to place the silhouette at a
specified position on the plot. If all three of these parameters are
unspecified, then the silhouette will be plotted to the full height and
width of the plot. The aspect ratio of the silhouette will always be
maintained (even when a figure is resized). However, if the plot is
resized afterwards, the absolute position of the silhouette may change.
}
\examples{
# single image
plot(1, 1, type="n", main="A cat")
add_phylopic_base(name = "Cat", x = 1, y = 1, ysize = .4)

# lots of images using a uuid
posx <- runif(50, 0, 1)
posy <- runif(50, 0, 1)
size <- runif(50, 0.01, 0.2)

# Since we are plotting a lot of the same image, we should just save
# the image in our environment first
cat <- get_phylopic("23cd6aa4-9587-4a2e-8e26-de42885004c9")

plot(posx, posy, type="n", main="A cat herd")
for (i in 1:50) {
  add_phylopic_base(cat, x = posx[i], y = posy[i], ysize = size[i])
}

# Example using a cat background
# setup plot area
plot(posx, posy, type="n", main="A cat herd, on top of a cat",
     xlim=c(0,1), ylim=c(0,1))
# plot background cat
add_phylopic_base(cat, alpha=0.2)
# overlay smaller cats
for (i in 1:50) {
  add_phylopic_base(cat, x = posx[i], y = posy[i], ysize = size[i], alpha=.8)
}
}
