% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_png.R
\name{save_png}
\alias{save_png}
\title{Save an image to disk as a \code{.png} file}
\usage{
save_png(img, target = tempfile(fileext = ".png"), ...)
}
\arguments{
\item{img}{A png object, e.g, from using \code{\link[=image_data]{image_data()}}}

\item{target}{the file or other connection to write to, passed
on to \link[png:writePNG]{png::writePNG}, see its docs for details. By default
we use \code{tempfile(fileext = ".png")}, a temporary \code{.png} file
which is cleaned up (deleted) at the end of the R session}

\item{...}{additional parameters passed on to \link[png:writePNG]{png::writePNG}}
}
\value{
path to the \code{.png} file on disk
}
\description{
Save an image to disk as a \code{.png} file
}
\examples{
\dontrun{
# get a silhouette
cat <- image_data("23cd6aa4-9587-4a2e-8e26-de42885004c9", size = 128)[[1]]

# save image
out <- save_png(cat)
identical(png::readPNG(out), cat)

save_png(cat, dpi = 1000)
}
}
