require("rphast")
exampleArchive <- system.file("extdata", "examples.zip", package="rphast")
files <- c("ENr334.fa", "gencode.ENr334.gff", "rev.mod")
unzip(exampleArchive, files)
tm <- read.tm("rev.mod")
tm$tree <- name.ancestors(tm$tree)
msa <- read.msa("ENr334.fa", offset=41405894)
phyloP(tm, msa, method="LRT", outfile="test.out", outfile.only=TRUE, outfile.format="wig")
t1 <- phyloP(tm, msa, method="LRT", outfile="test.out")
t2 <- phyloP(tm, msa, method="LRT", outfile="test.out", outfile.format="wig")
t1 <- phyloP(tm, msa, method="SPH")
f <- read.feat("gencode.ENr334.gff")
t1 <- phyloP(tm, msa, method="LRT", outfile="test.out", features=f)
t2 <- phyloP(tm, msa, method="LRT", features=f,
             outfile="test.out", outfile.format="gff", outfile.only=TRUE)

##' phyloP.prior
exampleArchive <- system.file("extdata", "examples.zip", package="rphast")
unzip(exampleArchive, "rev.mod")
tm <- read.tm("rev.mod")
t1 <- phyloP.prior(tm, nsites=10)
t2 <- phyloP.prior(tm, nsites=20)
t3 <- phyloP.prior(tm, nsites=20, quantiles=TRUE)
t4 <- phyloP.prior(tm, nsites=20, epsilon=1e-20)
plot(t1$nsub, t1$prior)
points(t2$nsub, t2$prior, col="red")
unlink("rev.mod")

## phyloP.sph (This is too slow for testing)
exampleArchive <- system.file("extdata", "examples.zip", package="rphast")
files <- c("ENr334.fa", "rev.mod")
unzip(exampleArchive, files)
tm <- read.tm("rev.mod")
t1 <- phyloP.sph(tm, prior.only=TRUE, nsites=20)
plot(t1$nsub, t1$prior.distrib)
msa <- sub.msa(read.msa("ENr334.fa", offset=41405894), end=10000)
t2 <- phyloP.sph(tm, msa)
t2
unlink(files)

#tm <- read.tm("rev.mod")
#msa <- sub.msa(read.msa("ENr334.fa", offset=41405894), end=10000)
#t2 <- phyloP.sph(tm, msa, subtree="hg18", post.only=TRUE)  # this takes a couple minutes

require("rphast")
file <- "gencode.ENr334.gff"
exampleArchive <- system.file("extdata", "examples.zip", package="rphast")
unzip(exampleArchive, file)
resultCons <- phyloP(tm, msa)
#resultAcc <- phyloP(tm, msa,  mode="ACC")
#resultConAcc <- phyloP(tm, msa,  mode="CONACC")
temp <- phyloP(tm, msa, mode="CONACC", outfile="test.out")
smallMsa <- sub.msa(msa, start.col=1000, end.col=1200)
#temp <- phyloP(tm, smallMsa, method="SPH")
temp <- phyloP(tm, smallMsa, method="LRT", subtree="mm9-rn4", outfile="test.out")
temp <- phyloP(tm, smallMsa, method="LRT", branches=c("mm9", "rn4"))
f <- read.feat(file)
temp <- phyloP(tm, msa, method="LRT", features=f)
phyloP(tm, msa, method="LRT", outfile="test.out", outfile.only=TRUE)
unlink("test.out")
unlink(file)


rm(list = ls())
gc()
