% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/rpg.R
\name{begin}
\alias{begin}
\alias{commit}
\alias{rollback}
\alias{savepoint}
\title{Transaction support}
\usage{
begin()

commit(savepoint = NULL)

rollback(savepoint = NULL)

savepoint()
}
\arguments{
\item{savepoint}{an object produced by \code{savepoint}}
}
\value{
\code{savepoint}: a savepoint object
}
\description{
Start, commit or rollback transactions or savepoints
}
\details{
These functions allow manipulation of database transaction states. If no
\code{savepoint} object is supplied, then an attempt is made to commit or
rollback the current transaction.

The \code{savepoint} function will initiate a transaction if one is not
currently active. In that case, no actual PostgreSQL savepoint will be used.
Rolling back the savepoint will rollback the initiated transaction. If a
tranaction is active, then a named savepoint will be generated. You can
\code{rollback} to the database state when \code{savepoint}
was called or \code{commit} all changes.
}
\examples{
\dontrun{
system("createdb rpgtesting")
connect("rpgtesting")
begin()
sp1 = savepoint()

# nest savepoints
sp2 = savepoint()
data(mtcars)
write_table(mtcars, "testtab", overwrite = TRUE)
list_tables()
rollback(sp2)

list_tables()
# nest savepoints
sp3 = savepoint()
sp4 = savepoint()
write_table(mtcars, "testtab", overwrite = TRUE)
commit(sp4)
list_tables()
rollback(sp3)
list_tables()

rollback(sp1)
rollback()
disconnect()
system("dropdb rpgtesting")}
}
\author{
Timothy H. Keitt
}

