% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/RcppExports.R, R/rpg.R
\name{result_dim}
\alias{execute}
\alias{fetch}
\alias{query}
\alias{query_error}
\alias{result_dim}
\title{PostgreSQL query}
\usage{
result_dim()

query(sql = "", pars = NULL)

query_error()

fetch(sql = "", pars = NULL)

execute(...)
}
\arguments{
\item{sql}{a query string}

\item{pars}{a character vector of substitution values}

\item{...}{list of commands to be \code{\link{paste}d} together}
}
\value{
\code{result_dim} returns the number of tuples and fields

\code{query} returns:
\tabular{ll}{
PGRES_EMPTY_QUERY \tab The string sent to the server was empty \cr
PGRES_COMMAND_OK \tab Successful completion of a command returning no data \cr
PGRES_TUPLES_OK \tab Successful completion of a command returning data (such as a SELECT or SHOW) \cr
PGRES_COPY_OUT \tab Copy Out (from server) data transfer started \cr
PGRES_COPY_IN \tab Copy In (to server) data transfer started \cr
PGRES_BAD_RESPONSE \tab The server's response was not understood. \cr
PGRES_NONFATAL_ERROR \tab A nonfatal error (a notice or warning) occurred \cr
PGRES_FATAL_ERROR \tab A fatal error occurred \cr
PGRES_COPY_BOTH \tab Copy In/Out (to and from server) data transfer started. This is currently used only for streaming replication \cr}

\code{query_error} returns an error string

\code{fetch} returns a data frame or a query status object on failure.

\code{execute} the result status string
}
\description{
Issue a query to the current database connection
}
\details{
\code{fetch} returns the result of a query as a data frame. If
\code{sql} is \code{NULL} or empty, then an attempt will be made to retrieve
any pending resutls from previous queries. Note that query results are not
cleared until the next query is issued so \code{fetch} will continue to
return results until a new query is issued.

\code{execute} is a wrapper around \code{query}. It will raise
an exception if the command does not complete. Exceptions can be caught with
\code{\link{tryCatch}}. You cannot use a parameterized
query with \code{execute}. Unlike \code{query} it will \code{\link{paste}} its
arguments into a single string.
}
\examples{
\dontrun{
system("createdb rpgtesting")
connect("rpgtesting")
begin()
execute("DROP SCHEMA IF EXISTS rpgtesting CASCADE")
execute("CREATE SCHEMA rpgtesting")
execute("SET search_path TO rpgtesting")
execute("DROP TABLE IF EXISTS test")
execute("CREATE TABLE test (id integer, field text)")
query("INSERT INTO test VALUES ($1, $2)", c(1, "test"))
fetch("SELECT * FROM test")
result_dim()
fetch("SELECT * FROM testing")
query_error()
rollback()
disconnect()
system("dropdb rpgtesting")}
}
\author{
Timothy H. Keitt
}
\seealso{
\code{\link{psql}}
}

