% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/util.R
\name{sumScoreEAP}
\alias{sumScoreEAP}
\title{Compute the sum-score EAP table}
\usage{
sumScoreEAP(grp, ..., qwidth = 6, qpoints = 49L, .twotier = TRUE)
}
\arguments{
\item{grp}{a list with spec, param, mean, and cov}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{qwidth}{positive width of quadrature in Z units}

\item{qpoints}{number of quadrature points}

\item{.twotier}{whether to enable the two-tier optimization}
}
\description{
Observed tables cannot be computed when data is
missing. Therefore, you can optionally omit items with the
greatest number of responses missing when conducting the
distribution test.
}
\details{
When two-tier covariance structure is detected, EAP scores are
only reported for primary factors. It is possible to compute EAP
scores for specific factors, but it is not clear why this would be
useful because they are conditional on the specific factor sum
scores. Moveover, the algorithm to compute them efficiently has not been
published yet (as of Jun 2014).
}
\examples{
# see Thissen, Pommerich, Billeaud, & Williams (1995, Table 2)
 spec <- list()
 spec[1:3] <- rpf.grm(outcomes=4)

 param <- matrix(c(1.87, .65, 1.97, 3.14,
                   2.66, .12, 1.57, 2.69,
                   1.24, .08, 2.03, 4.3), nrow=4)
 # fix parameterization
 param <- apply(param, 2, function(p) c(p[1], p[2:4] * -p[1]))

 grp <- list(spec=spec, mean=0, cov=matrix(1,1,1), param=param)
 sumScoreEAP(grp)
}

