% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Q4-class.R
\docType{data}
\name{Q4}
\alias{Q4}
\alias{as.Q4}
\alias{as.Q4.default}
\alias{as.Q4.SO3}
\alias{as.Q4.Q4}
\alias{as.Q4.data.frame}
\alias{is.Q4}
\alias{id.Q4}
\title{`Q4` class for storing rotation data as quaternions}
\format{
\code{id.Q4} is the identity rotation given by the matrix
  \eqn{[1,0,0,0]^\top}{[1,0,0,0]'}.

An object of class \code{Q4} with 1 rows and 4 columns.
}
\usage{
as.Q4(x, ...)

\method{as.Q4}{default}(x, theta = NULL, ...)

\method{as.Q4}{SO3}(x, ...)

\method{as.Q4}{Q4}(x, ...)

\method{as.Q4}{data.frame}(x, ...)

is.Q4(x)

id.Q4
}
\arguments{
\item{x}{object to be coerced or tested}

\item{...}{additional arguments.}

\item{theta}{vector or single rotation angle; if \code{length(theta)==1}, the
same theta is used for all axes}
}
\value{
\item{as.Q4}{coerces its object into a Q4 type}
  \item{is.Q4}{returns \code{TRUE} or \code{FALSE} depending on whether its
    argument satisfies the conditions to be an quaternion; namely it must be
    four-dimensional and of unit length}
}
\description{
Creates or tests for objects of class "Q4".
}
\details{
Construct a single or sample of rotations in 3-dimensions in quaternion form.
Several possible inputs for \code{x} are possible and they are differentiated
based on their class and dimension.

For \code{x} an n-by-3 matrix or a vector of length 3, the angle-axis
representation of rotations is utilized.  More specifically, each quaternion
can be interpreted as a rotation of some reference frame about the axis
\eqn{U} (of unit length) through the angle \eqn{\theta}.  For each axis and
angle the quaternion is formed through
\deqn{q=[cos(\theta/2),sin(\theta/2)U]^\top.}{q=[cos(theta/2),sin(theta/2)U]'.}
The object \code{x} is treated as if it has rows \eqn{U} and \code{theta} is
a vector or angles. If no angle is supplied then the length of each axis is
taken to be the angle of rotation theta.

For \code{x} an n-by-9 matrix of rotation matrices or an object of class
\code{"SO3"}, this function will return the quaternion equivalent of
\code{x}.  See \code{\link{SO3}} or the vignette "rotations-intro" for more
details on rotation matrices.

For \code{x} an n-by-4 matrix, rows are treated as quaternions; rows that
aren't of unit length are made unit length while the rest are returned
untouched.  A message is printed if any of the rows are not quaternions.

For \code{x} a \code{"data.frame"}, it is translated into a matrix of the
same dimension and the dimensionality of \code{x} is used to determine the
data type: angle-axis, quaternion or rotation (see above). As demonstrated
below, \code{is.Q4} may return \code{TRUE} for a data frame, but the
functions defined for objects of class \code{'Q4'} will not be called until
\code{as.Q4} has been used.
}
\examples{
# Pull off subject 1's wrist measurements
Subj1Wrist <- subset(drill, Subject == '1' & Joint == 'Wrist')

                               ## The measurements are in columns 5:8
all(is.Q4(Subj1Wrist[,5:8]))   #TRUE, even though Qs is a data.frame, the rows satisfy the
                               #conditions necessary to be quaternions BUT,
                               #S3 methods (e.g. 'mean' or 'plot') for objects of class
                               #'Q4' will not work until 'as.Q4' is used

Qs <- as.Q4(Subj1Wrist[,5:8])  #Coerce measurements into 'Q4' type using as.Q4.data.frame
all(is.Q4(Qs))                 #TRUE
mean(Qs)                       #Estimate central orientation for subject 1's wrist, see ?mean.Q4
Rs <- as.SO3(Qs)               #Coerce a 'Q4' object into rotation matrix format, see ?as.SO3

#Visualize the measurements, see ?plot.Q4 for more
\donttest{
  plot(Qs, col = c(1, 2, 3))
}
}
\keyword{datasets}
