% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Api.R
\name{api}
\alias{api}
\title{api wrapper function that checks for a user_key and determines the Rosette API endpoint to be utilized}
\usage{
api(user_key, endpoint, parameters = FALSE, customHeaders = NULL,
  url = "https://api.rosette.com/rest/v1/")
}
\arguments{
\item{user_key}{- Rosette API authentication key}

\item{endpoint}{- Rosette API endpoint to be utilized}

\item{parameters}{- parameters list to be passed to specified Rosette API endpoint}

\item{customHeaders}{- custom headers for Rosette Api}

\item{url}{- url for Rosette Api}
}
\value{
Returns json of the specified Rosette API endpoint response
}
\description{
api wrapper function that checks for a user_key and determines the Rosette API endpoint to be utilized
}
\examples{
\dontrun{
key <- "content"
value <- "Bill Murray will appear in new Ghostbusters film."
parameters <- list()
parameters[[ key ]] <- value
parameters <- toJSON(parameters)
api(01234567890, "entities", parameters)
}
}

