% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cities.R
\name{aq_cities}
\alias{aq_cities}
\title{Provides a simple listing of cities within the platform.}
\usage{
aq_cities(country = NULL, limit = 10000, page = NULL)
}
\arguments{
\item{country}{Limit results by a certain country -- a two-letters code see countries() for finding code based on name.}

\item{limit}{Change the number of results returned, max is 10000.}

\item{page}{The page of the results to query. This can be useful if e.g. there are 2000 measurements, then first use page=1 and page=2 with limit=100 to get all measurements for your query.}
}
\value{
A results data.frame (dplyr "tbl_df") with 5 columns:
\itemize{
\item city name ("city"), country code ("country"),
\item number of measures in total for the city ("count"),
\item number of locations ("locations"),
\item and also an URL encoded string for the city ("cityURL") which can be useful for
queries involving a city argument.
}
and 2 attributes, a meta data.frame (dplyr "tbl_df") with 1 line and 5 columns:
\itemize{
\item the API name ("name"),
\item the license of the data ("license"),
\item the website url ("website"),
\item the queried page ("page"),
\item the limit on the number of results ("limit"),
\item the number of results found on the platform for the query ("found")
}
and a timestamp data.frame (dplyr "tbl_df") with the query time and the last time at which the data was modified on the platform.
}
\description{
Provides a simple listing of cities within the platform.
}
\details{
For queries involving a city argument,
the URL-encoded name of the city (as in cityURL),
not its name, should be used.
}
\examples{
\dontrun{
cities <- aq_cities(country = "BA")
cities
}
}
