% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_classes.R
\name{convert_wide_to_tidy_omic}
\alias{convert_wide_to_tidy_omic}
\title{Convert Wide to Tidy Omic}
\usage{
convert_wide_to_tidy_omic(
  wide_df,
  feature_pk,
  feature_vars = NULL,
  sample_var = "sample",
  measurement_var = "abundance",
  omic_type_tag = "general"
)
}
\arguments{
\item{wide_df}{a data.frame (or tibble) containing 1+ columns of feature
attributes and many columns of samples}

\item{feature_pk}{A unique identifier for features}

\item{feature_vars}{a character vector of additional feature-level
variables (or NULL if there are no additional variables)}

\item{sample_var}{variable name to use for samples}

\item{measurement_var}{variable name to use for measurements}

\item{omic_type_tag}{an optional subtype of omic data: metabolomics,
lipidomics, proteomics, genomics, general}
}
\value{
A \code{tidy_omic} object as produced by \code{create_tidy_omic}.
}
\description{
Convert a wide dataset of species' abundances (gene product, metabolites,
  lipids, ...) into a triple_omic dataset (one observation per row)
}
\examples{

library(dplyr)

wide_measurements <- brauer_2008_triple[["measurements"]] \%>\%
  tidyr::spread(sample, expression)

wide_df <- brauer_2008_triple[["features"]] \%>\%
  left_join(wide_measurements, by = "name")

convert_wide_to_tidy_omic(wide_df,
  feature_pk = "name",
  feature_vars = c("BP", "MF", "systematic_name")
)
}
