% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deploy.R
\name{get_deployment_names}
\alias{get_deployment_names}
\alias{get_deployment_names.star_database}
\title{Get the names of the facts of a star database}
\usage{
get_deployment_names(db)

\method{get_deployment_names}{star_database}(db)
}
\arguments{
\item{db}{A \code{star_database} object.}
}
\value{
A vector of strings, fact names.
}
\description{
Obtain the names of the facts of a star database.
}
\examples{


mrs_rdb_file <- tempfile("mrs", fileext = ".rdb")
mrs_sqlite_file <- tempfile("mrs", fileext = ".sqlite")

mrs_sqlite_connect <- function() {
  DBI::dbConnect(RSQLite::SQLite(),
                 dbname = mrs_sqlite_file)
}

mrs_db <- mrs_db |>
  deploy(
    name = "mrs",
    connect = mrs_sqlite_connect,
    file = mrs_rdb_file
  )

names <- mrs_db |>
  get_deployment_names()

}
\seealso{
\code{\link{star_database}}

Other star database deployment functions: 
\code{\link{cancel_deployment}()},
\code{\link{deploy}()},
\code{\link{load_star_database}()}
}
\concept{star database deployment functions}
