% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_database.R
\name{set_fact_measure_names}
\alias{set_fact_measure_names}
\alias{set_fact_measure_names.star_database}
\title{Rename the measures of a star database}
\usage{
set_fact_measure_names(db, measures)

\method{set_fact_measure_names}{star_database}(db, measures)
}
\arguments{
\item{db}{A \code{star_database} object.}

\item{measures}{A vector of strings, measure names.}
}
\value{
A \code{star_database} object.
}
\description{
The measure names match those of the flat table from which they
are defined. This function allows you to change their names.
}
\examples{

db <- star_database(mrs_cause_schema, ft_num) |>
  set_fact_measure_names(
    measures = c(
      "Pneumonia and Influenza",
      "All",
      "Rows Aggregated"
    )
  )

}
\seealso{
\code{\link{as_tibble_list}}, \code{\link{as_dm_class}}

Other star database and constellation definition functions: 
\code{\link{constellation}()},
\code{\link{get_dimension_attribute_names}()},
\code{\link{get_fact_measure_names}()},
\code{\link{get_role_playing_dimension_names}()},
\code{\link{role_playing_dimension}()},
\code{\link{set_dimension_attribute_names}()},
\code{\link{snake_case}()},
\code{\link{star_database}()}
}
\concept{star database and constellation definition functions}
