% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_emails}
\alias{search_emails}
\title{Search Rodham's emails}
\usage{
search_emails(subject = NULL, to = NULL, from = NULL, start = NULL,
  end = NULL, internal = TRUE)
}
\arguments{
\item{subject}{Filter by subject, defaults to \code{NULL}(no filter). If
\code{internal = TRUE} then matches pattern, if \code{internal = FALSE} then
looks for exact match.}

\item{to}{Filter by Receiver, defaults to \code{NULL}(no filter).}

\item{from}{Filter by Sender, defaults to \code{NULL}(no filter).}

\item{start}{Filter by date range, defaults to \code{NULL}(no filter).}

\item{end}{Filter by date range, defaults to \code{NULL}(no filter).}

\item{internal}{if \code{TRUE} (default) searches the internal data set
(see \code{data(emails)}), if \code{FALSE} fetches the data through
the Wall Street journal API. \code{data(emails)} is equivalent to internal
\code{TRUE}}
}
\description{
Search Hillary Rodham Clinton's \emph{personal} emails.
}
\details{
There are a total of 29444 emails ranging from \code{2009-08-14} to
\code{2014-08-13}, please consider leaving internal to \code{TRUE} to not
hammer the Wall Street Journal's API. \code{internal = TRUE} is equivalent
to \code{\link{emails}}.
}
\examples{
\dontrun{
emails <- search_emails()

# only emails on cuba
emails <- search_emails(subject = "Cuba")

# only emails from Jake Sullivan since 2014
j_s <- search_emails(from = "Jake Sullivan", start = as.Date("2014-01-01"))
}

}
\author{
John Coene \email{jcoenep@gmail.com}
}

