% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunctions.R
\name{cv}
\alias{cv}
\title{Cross validation results for a model}
\usage{
cv(clinical_x = NULL, genomic_x = NULL, y = NULL, data = NULL,
  clinical_formula = NULL, family = "binomial", folds = NULL, k = 10,
  fit_method = "glm", method_name = NULL, n.cores = 1, ...)
}
\arguments{
\item{clinical_x}{clinical variables that will always be included in the model}

\item{genomic_x}{genomic variables that will be penalized if a penalized model is used}

\item{y}{response variables}

\item{data}{dataframe if clinical formula is used}

\item{clinical_formula}{formula for clinical variables}

\item{family}{gaussian, binomial or poisson}

\item{folds}{predefined partions for cross validation}

\item{k}{number of cross validation folds. A value of k=n is leave one out cross validation.}

\item{fit_method}{glm or glmnet used to fit the model}

\item{method_name}{tracking variable to include in return dataframe}

\item{n.cores}{Number of cores to be used}

\item{...}{additional commmands to glm or cv.glmnet}
}
\value{
returns a dataframe of predicted values and observed values. In addition, method_name is recorded if that variable is defined.
}
\description{
Cross validation results for a model
}
\examples{
x <- matrix(rnorm(800),ncol=8)
y <- runif(100) < exp(1 + x[,1] + x[,5])/(1+exp(1 + x[,1] + x[,5]))
cv_results <- cv(x,y=y,method_name="without_formula")
combined_data <- data.frame(y=y,x1=x[,1],x5=x[,5])
gx <- x[,c(2,3,4,6,7,8)]
cvf <- cv(genomic_x=gx,clinical_formula=y~x1+x5,data=combined_data,method_name="with_form")
}
\author{
Ben Sherwood <bsherwo2@jhu.edu>
}

