% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discipline_pruning.R
\name{PruneDisciplines}
\alias{PruneDisciplines}
\title{Set of permissible disciplines for redistribution.}
\usage{
PruneDisciplines(r, tolerance = 1, similarity)
}
\arguments{
\item{r}{A logical vector indicating which disciplines are referenced by the current document.
Its length is equal to the total number of disciplines.}

\item{tolerance}{A real number in the interval [0,1].
This argument modulates the similarity between disciplines with which the strictness of the pruning of unlikely disciplines is controlled.
A value of 0 allows all disciplines to participate in the redistribution process.
A value of 1 permits no tolerance.
This argument is optional and leaving it unspecified deactivates tolerances.}

\item{similarity}{A positive semi-definite matrix that encodes the similarity between disciplines, as explained in Porter and Rafols (2009).
The dimensions of this matrix are \emph{n} x \emph{n}, being \emph{n} the total number of disciplines.
The number of rows and the number of columns of this matrix needs to be equal to the length of \code{r}.
The self-similarities (i.e. the diagonal elements) have to be 1.}
}
\value{
A logical vector indicating to which disciplines a reference redistribution is permissible.
}
\description{
Computes the set of disciplines to which uncategorized references can be redistributed.
This set is computed taking into account the mutual similarities of the already referenced disciplines, as explained in Calatrava et al. (2016).
This function allows to set a tolerance of similarity that only permits similar disciplines to participate in the redistribution process.
Therefore, it avoids redistributions that include very dissimilar and improbable disciplines.
}
\examples{
#Load data
data(pubdata1)

#Get counts of citations of one of the publications in the dataset
counts <- pd1.count.matrix[,1]

#Get logical vector indicating which disciplines are referenced by the publication
logic.disciplines <- counts > 0

PruneDisciplines(logic.disciplines, 0.233, pd1.similarity)
}
\references{
Calatrava Moreno, M. C., Auzinger, T. and Werthner, H. (2016) On the uncertainty of interdisciplinarity measurements due to incomplete bibliographic data. Scientometrics. DOI:10.1007/s11192-016-1842-4

Porter, A. and Rafols, I. (2009) Is science becoming more interdisciplinary? Measuring and mapping six research fields over time. Scientometrics, Vol. 81, No. 3 (719-745). DOI:10.1007/s11192-008-2197-2
}

