% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitDatasets.R
\name{shortenLabelsKS2022}
\alias{shortenLabelsKS2022}
\title{Shorten Labels}
\usage{
shortenLabelsKS2022(labels)
}
\arguments{
\item{labels}{vector of labels as assigned by \code{\link{fitDatasets}}}
}
\value{
Vector of shortened labels
}
\description{
Shorten labels created by the various \code{\link{fitDatasets}} functions,
for use in plotting, etc.
}
\details{
The labels are shortened as they are in the simulation study published in
Koller and Stahel (2022).
}
\examples{
  labels <- c("fitDatasets_lmer", "fitDatasets_rlmer_DAStau",
              "fitDatasets_rlmer_DAStau_noAdj",
              "fitDatasets_varComprob_compositeTau_OGK",
              "fitDatasets_varComprob_S_OGK",
              "fitDatasets_heavyLme",
              "fitDatasets_lqmm")
  shortenLabelsKS2022(labels)
}
\references{
Koller M, Stahel WA (2022). "Robust Estimation of General Linear
 Mixed Effects Models.” In PM Yi, PK Nordhausen (eds.), Robust and Multivariate
 Statistical Methods, Springer Nature Switzerland AG.
}
\author{
Manuel Koller
}
