% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{get.variable.genes}
\alias{get.variable.genes}
\title{Identify Highly Variable Genes}
\usage{
get.variable.genes(environment, min.mean = 0.05, min.frac.cells = 0,
  min.dispersion.scaled = 1, rerun = F)
}
\arguments{
\item{environment}{\code{environment} object}

\item{min.mean}{minimum mean expression per gene}

\item{min.frac.cells}{minimum fraction of cells expressing each gene}

\item{min.dispersion.scaled}{minimum dispersion value}

\item{rerun}{whether to rerun the analysis or load from cache}
}
\value{
\code{environment} parameter containing highly variable genes selection
}
\description{
Get highly variable genes by Heteroscedasticity controlled binning of gene expression measurements within each dataset separately.
}
\examples{
LCMV1 <- setup_LCMV_example()
LCMV1 <- get.variable.genes(LCMV1)
}
