% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmean.R
\name{gmean_sum}
\alias{gmean_sum}
\alias{gmean}
\title{geometric mean}
\usage{
gmean_sum(x, margin = NULL)

gmean(x, margin = NULL)
}
\arguments{
\item{x}{matrix or data.frame with numeric entries}

\item{margin}{a vector giving the subscripts which the function will be applied over, 
1 indicates rows, 2 indicates columns, 3 indicates all values.}
}
\value{
geometric means (if \code{gmean} is used) or totals (if \code{gmean_sum} is used)
}
\description{
Computes the geometric mean(s) of a numeric vector, matrix or data.frame
}
\details{
\code{gmean_sum} calculates the totals based on geometric means while \code{gmean}
calculates geometric means on rows (margin = 1), on columns (margin = 2), or on all values (margin = 3)
}
\examples{
data("precipitation")
gmean_sum(precipitation)
gmean_sum(precipitation, margin = 2)
gmean_sum(precipitation, margin = 1)
gmean_sum(precipitation, margin = 3)
addmargins(precipitation)
addmargins(precipitation, FUN = gmean_sum)
addmargins(precipitation, FUN = mean)
addmargins(precipitation, FUN = gmean)

data("arcticLake", package = "robCompositions")
gmean(arcticLake$sand)
gmean(as.numeric(arcticLake[1, ]))
gmean(arcticLake)
gmean(arcticLake, margin = 1)
gmean(arcticLake, margin = 2)
gmean(arcticLake, margin = 3)
}
\author{
Matthias Templ
}
