% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fData.R
\name{unfold}
\alias{unfold}
\title{Unfolding a univariate functional dataset}
\usage{
unfold(fData)
}
\arguments{
\item{fData}{the unvariate functional dataset in form of \code{fData} object.}
}
\value{
The function returns an \code{fData} object whose observations are
the unfolded version of the corresponding observations in the argument
\code{fData}.
}
\description{
This function operates on a univariate functional dataset and transforms its
observations unfolding their values and turning them into monotone functions.
}
\details{
Each function of the \code{fData} object is transformed into a nonmonotone
function into a monotone function by ``unfolding'' it at any of its maxima.
For more details about the definition of the transform, see the reference.
}
\examples{
P = 1e3

time_grid = seq( 0, 1, length.out = P )

D = matrix( c( sin( 2 * pi * time_grid ),
               cos( 2 * pi * time_grid ),
               sin( 10 * pi * time_grid ) * time_grid + 2 ),
            ncol = P, nrow = 3, byrow = TRUE )

# Functional dataset
fD = fData( time_grid, D )

# Unfolded version
fD_unfold = unfold( fD )

dev.new()
par( mfrow = c( 1, 2 ) )
plot( fD, main = 'Original data' )
plot( fD_unfold, main = 'Unfolded data' )

}
\references{
Arribas-Gil, A. and Romo, J. (2012). Robust depth-based estimation
in the time warping model, \emph{Biostatistics}, 13 (3), 398--414.
}
\seealso{
\code{\link{fData}}, \code{\link{warp}}
}

