% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ncdc_stations.r
\name{ncdc_stations}
\alias{ncdc_stations}
\title{Get metadata about NOAA NCDC stations.}
\usage{
ncdc_stations(stationid = NULL, datasetid = NULL, datatypeid = NULL,
  locationid = NULL, startdate = NULL, enddate = NULL, sortfield = NULL,
  sortorder = NULL, limit = 25, offset = NULL, datacategoryid = NULL,
  extent = NULL, radius = 10, token = NULL, dataset = NULL,
  station = NULL, location = NULL, locationtype = NULL, page = NULL,
  ...)
}
\arguments{
\item{stationid}{Accepts a valid station id or a chain of of station ids in a
comma-separated vector. Data returned will contain data for the station(s) specified (optional)}

\item{datasetid}{(optional) Accepts a single valid dataset id. Data returned will be from the
dataset specified, see datasets()}

\item{datatypeid}{Accepts a valid data type id or a chain of data type ids in a
   comma-separated vector. Data returned will contain all of the data type(s) specified
(optional)}

\item{locationid}{Accepts a valid location id or a chain of location ids in a
comma-separated vector. Data returned will contain data for the location(s) specified (optional)}

\item{startdate}{(optional) Accepts valid ISO formated date (yyyy-mm-dd) or date time
(YYYY-MM-DDThh:mm:ss). Data returned will have data after the specified date. The
date range must be less than 1 year.}

\item{enddate}{(optional) Accepts valid ISO formated date (yyyy-mm-dd) or date time
(YYYY-MM-DDThh:mm:ss). Data returned will have data before the specified date. The
date range must be less than 1 year.}

\item{sortfield}{The field to sort results by. Supports id, name, mindate, maxdate, and
datacoverage fields (optional)}

\item{sortorder}{Which order to sort by, asc or desc. Defaults to asc (optional)}

\item{limit}{Defaults to 25, limits the number of results in the response. Maximum is
1000 (optional)}

\item{offset}{Defaults to 0, used to offset the resultlist (optional)}

\item{datacategoryid}{(character, optional) Accepts a valid data category id or an
array of data category ids.  Stations returned will be associated with the data
category(ies) specified}

\item{extent}{(numeric, optional) The geographical extent for which you want to
search. Give either a vecctor with two values: a latitude and a longitude. For
example, \code{c(lat,long)}. Or give four values that defines a bounding box,
lat and long for the southwest corner, then lat and long for the northeast corner.
For example: \code{c(minlat, minlong, maxlat, maxlong)}.}

\item{radius}{(numeric) If a single latitude/longitude pair is given to the extent
parameter, the radius to create around the point. Ignored if a vector of appropriate
structure is passed to the  extent parameter.}

\item{token}{This must be a valid token token supplied to you by NCDC's Climate
Data Online access token generator. (required) Get an API key (=token) at
http://www.ncdc.noaa.gov/cdo-web/token. You can pass your token in as
an argument or store it in your .Rprofile file with an entry like
\itemize{
  \item options("noaakey" = "your-noaa-token")
}}

\item{dataset}{THIS IS A DEPRECATED ARGUMENT. See datasetid.}

\item{station}{THIS IS A DEPRECATED ARGUMENT. See stationid.}

\item{location}{THIS IS A DEPRECATED ARGUMENT. See locationid.}

\item{locationtype}{THIS IS A DEPRECATED ARGUMENT. There is no equivalent argument in v2
of the NOAA API.}

\item{page}{THIS IS A DEPRECATED ARGUMENT. There is no equivalent argument in v2
of the NOAA API.}

\item{...}{Further named parameters, such as \code{query}, \code{path}, etc, passed on to
\code{\link[httr]{modify_url}}. Unnamed parameters will be combined with
\code{\link[httr]{config}}.}
}
\value{
A list of metadata.
}
\description{
From the NOAA NCDC API docs: Stations are where the data comes from (for most datasets)
and can be considered the smallest granual of location data. If you know what
station you want, you can quickly get all manner of data from it
}
\examples{
\dontrun{
# Get metadata on all stations
ncdc_stations()
ncdc_stations(limit=5)

# Get metadata on a single station
ncdc_stations(stationid='COOP:010008')

# Displays all stations within GHCN-Daily (100 Stations per page limit)
ncdc_stations(datasetid='GHCND')

# Station
ncdc_stations(datasetid='NORMAL_DLY', stationid='GHCND:USW00014895')

# Displays all stations within GHCN-Daily (Displaying page 10 of the results)
ncdc_stations(datasetid='GHCND')

# Specify datasetid and locationid
ncdc_stations(datasetid='GHCND', locationid='FIPS:12017')

# Specify datasetid, locationid, and station
ncdc_stations(datasetid='GHCND', locationid='FIPS:12017', stationid='GHCND:USC00084289')

# Specify datasetid, locationidtype, locationid, and station
ncdc_stations(datasetid='GHCND', locationid='FIPS:12017', stationid='GHCND:USC00084289')

# Displays list of stations within the specified county
ncdc_stations(datasetid='GHCND', locationid='FIPS:12017')

# Displays list of Hourly Precipitation locationids between 01/01/1990 and 12/31/1990
ncdc_stations(datasetid='PRECIP_HLY', startdate='19900101', enddate='19901231')

# Search for stations by spatial extent
## Search using a bounding box, w/ lat/long of the SW corner, then of NE corner
ncdc_stations(extent=c(47.5204,-122.2047,47.6139,-122.1065))
}
}

