% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnaCrosslinkDataSet.R
\docType{class}
\name{rnaCrosslinkDataSet-class}
\alias{rnaCrosslinkDataSet-class}
\alias{rnaCrosslinkDataSet}
\title{rnaCrosslinkDataSet}
\usage{
rnaCrosslinkDataSet(
  rnas,
  rnaSize = 0,
  sampleTable,
  subset = "all",
  sample = "all"
)
}
\arguments{
\item{rnas}{vector - The names of the RNA interest, these must be displayed
the same way as in the input Input Files.}

\item{rnaSize}{named list - The sizes (nt) of the RNAs of interest, the list
elements must have same names as the \code{rnas} vector and each each contain
one numeric value.}

\item{sampleTable}{string - The address of the sample table, the sample table
must have 4 columns, fileName (the full path and file name of the input
Input file for each sample ), group ("s" - sample or "c" - control),
sample (1,2,3, etc), sampleName (must be unique).}

\item{subset}{a vector of 4 values to subset based on structural read size. c(l-min,l-max,r-min,r-max)}

\item{sample}{The number of reads to sample for each sample.}
}
\value{
A rnaCrosslinkDataSet object.
}
\description{
\code{rnaCrosslinkDataSet} objects are used to store the input meta-data, data and
create a framework for the storage of results. Whilst creating the object,
the original Input files are also filtered for the RNA of interest. Check the 
package vignette for more information.
}
\section{Slots}{

\describe{
\item{\code{clusterTableFolded}}{table - a table similar to the \code{clusterTableList}
it contains coordinates of the clusters along with vienna format fold and
RNA sequences for each cluster}

\item{\code{clusterTableList}}{List - Follows the pattern for list slots of rnaCrosslinkDataSet
objects, \code{matrixList(cds)[[rna]][[type]][[sample]]}. contains a table
with coordinates and information about the clusters identified}

\item{\code{clusterGrangesList}}{List - Follows the pattern for list slots of rnaCrosslinkDataSet
objects, \code{matrixList(cds)[[rna]][[type]][[sample]]}. contains GRanges
objects of the original duplexes with their cluster membership}

\item{\code{sampleTable}}{table - Column names; fileName, group (s or c),
sample (1,2,3, etc), sampleName (must be unique)}

\item{\code{rnas}}{string - a single RNA to analyse - must be present in \code{rnas(cdsObject)}}

\item{\code{rnaSize}}{if set to 0 this will be calculated}

\item{\code{matrixList}}{List - Follows the pattern for list slots of rnaCrosslinkDataSet
objects, \code{matrixList(cds)[[rna]][[type]][[sample]]}. Contains a set
of contact matrices, each cell contains the number of duplexes identified
for position x,y.}

\item{\code{InputFiles}}{List - Follows the pattern for list slots of rnaCrosslinkDataSet
objects, \code{InputFiles(cds)[[rna]][[type]][[sample]]}. Contains a set of
tables, these are the original Input files that were read in.}

\item{\code{interactionTable}}{Table of interactions discovered in step1 of the folding}

\item{\code{viennaStructures}}{List of vienna format structures from final prediction}

\item{\code{dgs}}{List of free energies}
}}

\examples{
# make example input
cds = makeExamplernaCrosslinkDataSet()

cds

}
