% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{pcp}
\alias{pcp}
\title{Parallel Coordinate Plots}
\usage{
pcp(object)
}
\arguments{
\item{object}{An object of nsga-class, nsga2-class or nsga3-class.
See \linkS4class{nsga}, \linkS4class{nsga2} or \linkS4class{nsga3} for a description of
available slots information.}
}
\description{
The \code{pcp()} function for hyperdimensional data visualization,
which represents a p-dimensional data point in Cartesian coordinates by a
polyline (or curve) intercepting n-parallel axes, where p or the x-axis
represents the fitness values and n or the y-axis represents the objectives.
}
\examples{
#Four Objectives Plotting
dtlz1 <- function (x, nobj = 4){
    if (is.null(dim(x))) {
        x <- matrix(x, 1)
    }
    n <- ncol(x)
    y <- matrix(x[, 1:(nobj - 1)], nrow(x))
    z <- matrix(x[, nobj:n], nrow(x))
    g <- 100 * (n - nobj + 1 + rowSums((z - 0.5)^2 - cos(20 * pi * (z - 0.5))))
    tmp <- t(apply(y, 1, cumprod))
    tmp <- cbind(t(apply(tmp, 1, rev)), 1)
    tmp2 <- cbind(1, t(apply(1 - y, 1, rev)))
    f <- tmp * tmp2 * 0.5 * (1 + g)
    return(f)
}

#Not Run
\dontrun{
result <- nsga3(type = "real-valued",
                fitness = dtlz1,
                lower = c(0,0,0,0),
                upper = c(1,1,1,1),
                popSize = 92,
                n_partitions = 12,
                monitor = FALSE,
                maxiter = 500)
}
#Not Run
\dontrun{
pcp(object = result)
}

}
\author{
Francisco Benitez
\email{benitezfj94@gmail.com}
}
