/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.rules.Rule;
import weka.classifiers.rules.RuleStats;
import weka.core.AdditionalMeasureProducer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Copyable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.supervised.attribute.ClassOrder;

public class JRip
extends Classifier
implements AdditionalMeasureProducer,
WeightedInstancesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -6589312996832147161L;
    private static double MAX_DL_SURPLUS = 64.0;
    private Attribute m_Class;
    private FastVector m_Ruleset;
    private FastVector m_Distributions;
    private int m_Optimizations = 2;
    private Random m_Random = null;
    private double m_Total = 0.0;
    private long m_Seed = 1L;
    private int m_Folds = 3;
    private double m_MinNo = 2.0;
    private boolean m_Debug = false;
    private boolean m_CheckErr = true;
    private boolean m_UsePruning = true;
    private Filter m_Filter = null;
    private FastVector m_RulesetStats;

    public String globalInfo() {
        return "This class implements a propositional rule learner, Repeated Incremental Pruning to Produce Error Reduction (RIPPER), which was proposed by William W. Cohen as an optimized version of IREP. \n\nThe algorithm is briefly described as follows: \n\nInitialize RS = {}, and for each class from the less prevalent one to the more frequent one, DO: \n\n1. Building stage:\nRepeat 1.1 and 1.2 until the descrition length (DL) of the ruleset and examples is 64 bits greater than the smallest DL met so far, or there are no positive examples, or the error rate >= 50%. \n\n1.1. Grow phase:\nGrow one rule by greedily adding antecedents (or conditions) to the rule until the rule is perfect (i.e. 100% accurate).  The procedure tries every possible value of each attribute and selects the condition with highest information gain: p(log(p/t)-log(P/T)).\n\n1.2. Prune phase:\nIncrementally prune each rule and allow the pruning of any final sequences of the antecedents;The pruning metric is (p-n)/(p+n) -- but it's actually 2p/(p+n) -1, so in this implementation we simply use p/(p+n) (actually (p+1)/(p+n+2), thus if p+n is 0, it's 0.5).\n\n2. Optimization stage:\n after generating the initial ruleset {Ri}, generate and prune two variants of each rule Ri from randomized data using procedure 1.1 and 1.2. But one variant is generated from an empty rule while the other is generated by greedily adding antecedents to the original rule. Moreover, the pruning metric used here is (TP+TN)/(P+N).Then the smallest possible DL for each variant and the original rule is computed.  The variant with the minimal DL is selected as the final representative of Ri in the ruleset.After all the rules in {Ri} have been examined and if there are still residual positives, more rules are generated based on the residual positives using Building Stage again. \n3. Delete the rules from the ruleset that would increase the DL of the whole ruleset if it were in it. and add resultant ruleset to RS. \nENDDO\n\nNote that there seem to be 2 bugs in the original ripper program that would affect the ruleset size and accuracy slightly.  This implementation avoids these bugs and thus is a little bit different from Cohen's original implementation. Even after fixing the bugs, since the order of classes with the same frequency is not defined in ripper, there still seems to be some trivial difference between this implementation and the original ripper, especially for audiology data in UCI repository, where there are lots of classes of few instances.\n\nDetails please see:\n\n" + this.getTechnicalInformation().toString() + "\n\n" + "PS.  We have compared this implementation with the original ripper " + "implementation in aspects of accuracy, ruleset size and running time " + "on both artificial data \"ab+bcd+defg\" and UCI datasets.  In all these " + "aspects it seems to be quite comparable to the original ripper " + "implementation.  However, we didn't consider memory consumption " + "optimization in this implementation.\n\n";
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "William W. Cohen");
        result.setValue(TechnicalInformation.Field.TITLE, "Fast Effective Rule Induction");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Twelfth International Conference on Machine Learning");
        result.setValue(TechnicalInformation.Field.YEAR, "1995");
        result.setValue(TechnicalInformation.Field.PAGES, "115-123");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann");
        return result;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(3);
        newVector.addElement(new Option("\tSet number of folds for REP\n\tOne fold is used as pruning set.\n\t(default 3)", "F", 1, "-F <number of folds>"));
        newVector.addElement(new Option("\tSet the minimal weights of instances\n\twithin a split.\n\t(default 2.0)", "N", 1, "-N <min. weights>"));
        newVector.addElement(new Option("\tSet the number of runs of\n\toptimizations. (Default: 2)", "O", 1, "-O <number of runs>"));
        newVector.addElement(new Option("\tSet whether turn on the\n\tdebug mode (Default: false)", "D", 0, "-D"));
        newVector.addElement(new Option("\tThe seed of randomization\n\t(Default: 1)", "S", 1, "-S <seed>"));
        newVector.addElement(new Option("\tWhether NOT check the error rate>=0.5\n\tin stopping criteria \t(default: check)", "E", 0, "-E"));
        newVector.addElement(new Option("\tWhether NOT use pruning\n\t(default: use pruning)", "P", 0, "-P"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String numFoldsString = Utils.getOption('F', options);
        this.m_Folds = numFoldsString.length() != 0 ? Integer.parseInt(numFoldsString) : 3;
        String minNoString = Utils.getOption('N', options);
        this.m_MinNo = minNoString.length() != 0 ? Double.parseDouble(minNoString) : 2.0;
        String seedString = Utils.getOption('S', options);
        this.m_Seed = seedString.length() != 0 ? Long.parseLong(seedString) : 1L;
        String runString = Utils.getOption('O', options);
        this.m_Optimizations = runString.length() != 0 ? Integer.parseInt(runString) : 2;
        this.m_Debug = Utils.getFlag('D', options);
        this.m_CheckErr = !Utils.getFlag('E', options);
        this.m_UsePruning = !Utils.getFlag('P', options);
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[11];
        int current = 0;
        options[current++] = "-F";
        options[current++] = "" + this.m_Folds;
        options[current++] = "-N";
        options[current++] = "" + this.m_MinNo;
        options[current++] = "-O";
        options[current++] = "" + this.m_Optimizations;
        options[current++] = "-S";
        options[current++] = "" + this.m_Seed;
        if (this.m_Debug) {
            options[current++] = "-D";
        }
        if (!this.m_CheckErr) {
            options[current++] = "-E";
        }
        if (!this.m_UsePruning) {
            options[current++] = "-P";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(1);
        newVector.addElement("measureNumRules");
        return newVector.elements();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.compareToIgnoreCase("measureNumRules") == 0) {
            return this.m_Ruleset.size();
        }
        throw new IllegalArgumentException(String.valueOf(additionalMeasureName) + " not supported (RIPPER)");
    }

    public String foldsTipText() {
        return "Determines the amount of data used for pruning. One fold is used for pruning, the rest for growing the rules.";
    }

    public void setFolds(int fold) {
        this.m_Folds = fold;
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String minNoTipText() {
        return "The minimum total weight of the instances in a rule.";
    }

    public void setMinNo(double m) {
        this.m_MinNo = m;
    }

    public double getMinNo() {
        return this.m_MinNo;
    }

    public String seedTipText() {
        return "The seed used for randomizing the data.";
    }

    public void setSeed(long s) {
        this.m_Seed = s;
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String optimizationsTipText() {
        return "The number of optimization runs.";
    }

    public void setOptimizations(int run) {
        this.m_Optimizations = run;
    }

    public int getOptimizations() {
        return this.m_Optimizations;
    }

    @Override
    public String debugTipText() {
        return "Whether debug information is output to the console.";
    }

    @Override
    public void setDebug(boolean d) {
        this.m_Debug = d;
    }

    @Override
    public boolean getDebug() {
        return this.m_Debug;
    }

    public String checkErrorRateTipText() {
        return "Whether check for error rate >= 1/2 is included in stopping criterion.";
    }

    public void setCheckErrorRate(boolean d) {
        this.m_CheckErr = d;
    }

    public boolean getCheckErrorRate() {
        return this.m_CheckErr;
    }

    public String usePruningTipText() {
        return "Whether pruning is performed.";
    }

    public void setUsePruning(boolean d) {
        this.m_UsePruning = d;
    }

    public boolean getUsePruning() {
        return this.m_UsePruning;
    }

    public FastVector getRuleset() {
        return this.m_Ruleset;
    }

    public RuleStats getRuleStats(int pos) {
        return (RuleStats)this.m_RulesetStats.elementAt(pos);
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(this.m_Folds);
        return result;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_Random = instances.getRandomNumberGenerator(this.m_Seed);
        this.m_Total = RuleStats.numAllConditions(instances);
        if (this.m_Debug) {
            System.err.println("Number of all possible conditions = " + this.m_Total);
        }
        Instances data = null;
        this.m_Filter = new ClassOrder();
        ((ClassOrder)this.m_Filter).setSeed(this.m_Random.nextInt());
        ((ClassOrder)this.m_Filter).setClassOrder(0);
        this.m_Filter.setInputFormat(instances);
        data = Filter.useFilter(instances, this.m_Filter);
        if (data == null) {
            throw new Exception(" Unable to randomize the class orders.");
        }
        this.m_Class = data.classAttribute();
        this.m_Ruleset = new FastVector();
        this.m_RulesetStats = new FastVector();
        this.m_Distributions = new FastVector();
        double[] orderedClasses = ((ClassOrder)this.m_Filter).getClassCounts();
        if (this.m_Debug) {
            System.err.println("Sorted classes:");
            int x = 0;
            while (x < this.m_Class.numValues()) {
                System.err.println(String.valueOf(x) + ": " + this.m_Class.value(x) + " has " + orderedClasses[x] + " instances.");
                ++x;
            }
        }
        int y = 0;
        while (y < data.numClasses() - 1) {
            double classIndex = y;
            if (this.m_Debug) {
                int ci = (int)classIndex;
                System.err.println("\n\nClass " + this.m_Class.value(ci) + "(" + ci + "): " + orderedClasses[y] + "instances\n" + "=====================================\n");
            }
            if (!Utils.eq(orderedClasses[y], 0.0)) {
                double all = 0.0;
                int i = y;
                while (i < orderedClasses.length) {
                    all += orderedClasses[i];
                    ++i;
                }
                double expFPRate = orderedClasses[y] / all;
                double classYWeights = 0.0;
                double totalWeights = 0.0;
                int j = 0;
                while (j < data.numInstances()) {
                    Instance datum = data.instance(j);
                    totalWeights += datum.weight();
                    if ((int)datum.classValue() == y) {
                        classYWeights += datum.weight();
                    }
                    ++j;
                }
                if (classYWeights > 0.0) {
                    double defDL = RuleStats.dataDL(expFPRate, 0.0, totalWeights, 0.0, classYWeights);
                    if (Double.isNaN(defDL) || Double.isInfinite(defDL)) {
                        throw new Exception("Should never happen: defDL NaN or infinite!");
                    }
                    if (this.m_Debug) {
                        System.err.println("The default DL = " + defDL);
                    }
                    data = this.rulesetForOneClass(expFPRate, data, classIndex, defDL);
                }
            }
            ++y;
        }
        RipperRule defRule = new RipperRule();
        defRule.setConsequent(data.numClasses() - 1);
        this.m_Ruleset.addElement(defRule);
        RuleStats defRuleStat = new RuleStats();
        defRuleStat.setData(data);
        defRuleStat.setNumAllConds(this.m_Total);
        defRuleStat.addAndUpdate(defRule);
        this.m_RulesetStats.addElement(defRuleStat);
        int z = 0;
        while (z < this.m_RulesetStats.size()) {
            RuleStats oneClass = (RuleStats)this.m_RulesetStats.elementAt(z);
            int xyz = 0;
            while (xyz < oneClass.getRulesetSize()) {
                double[] classDist = oneClass.getDistributions(xyz);
                Utils.normalize(classDist);
                if (classDist != null) {
                    this.m_Distributions.addElement(((ClassOrder)this.m_Filter).distributionsByOriginalIndex(classDist));
                }
                ++xyz;
            }
            ++z;
        }
        int i = 0;
        while (i < this.m_RulesetStats.size()) {
            ((RuleStats)this.m_RulesetStats.elementAt(i)).cleanUp();
            ++i;
        }
    }

    @Override
    public double[] distributionForInstance(Instance datum) {
        try {
            int i = 0;
            while (i < this.m_Ruleset.size()) {
                RipperRule rule = (RipperRule)this.m_Ruleset.elementAt(i);
                if (rule.covers(datum)) {
                    return (double[])this.m_Distributions.elementAt(i);
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        System.err.println("Should never happen!");
        return new double[datum.classAttribute().numValues()];
    }

    protected Instances rulesetForOneClass(double expFPRate, Instances data, double classIndex, double defDL) throws Exception {
        double[] rst;
        Instances pruneData;
        Instances growData;
        boolean defHasPositive;
        Instances newData = data;
        boolean stop = false;
        FastVector ruleset = new FastVector();
        double dl = defDL;
        double minDL = defDL;
        RuleStats rstats = null;
        boolean hasPositive = defHasPositive = true;
        if (this.m_Debug) {
            System.err.println("\n*** Building stage ***");
        }
        while (!stop && hasPositive) {
            RipperRule oneRule;
            if (this.m_UsePruning) {
                newData = RuleStats.stratify(newData, this.m_Folds, this.m_Random);
                Instances[] part = RuleStats.partition(newData, this.m_Folds);
                growData = part[0];
                pruneData = part[1];
                oneRule = new RipperRule();
                oneRule.setConsequent(classIndex);
                if (this.m_Debug) {
                    System.err.println("\nGrowing a rule ...");
                }
                oneRule.grow(growData);
                if (this.m_Debug) {
                    System.err.println("One rule found before pruning:" + oneRule.toString(this.m_Class));
                }
                if (this.m_Debug) {
                    System.err.println("\nPruning the rule ...");
                }
                oneRule.prune(pruneData, false);
                if (this.m_Debug) {
                    System.err.println("One rule found after pruning:" + oneRule.toString(this.m_Class));
                }
            } else {
                oneRule = new RipperRule();
                oneRule.setConsequent(classIndex);
                if (this.m_Debug) {
                    System.err.println("\nNo pruning: growing a rule ...");
                }
                oneRule.grow(newData);
                if (this.m_Debug) {
                    System.err.println("No pruning: one rule found:\n" + oneRule.toString(this.m_Class));
                }
            }
            if (rstats == null) {
                rstats = new RuleStats();
                rstats.setNumAllConds(this.m_Total);
                rstats.setData(newData);
            }
            rstats.addAndUpdate(oneRule);
            int last = rstats.getRuleset().size() - 1;
            if (Double.isNaN(dl += rstats.relativeDL(last, expFPRate, this.m_CheckErr)) || Double.isInfinite(dl)) {
                throw new Exception("Should never happen: dl in building stage NaN or infinite!");
            }
            if (this.m_Debug) {
                System.err.println("Before optimization(" + last + "): the dl = " + dl + " | best: " + minDL);
            }
            if (dl < minDL) {
                minDL = dl;
            }
            rst = rstats.getSimpleStats(last);
            if (this.m_Debug) {
                System.err.println("The rule covers: " + rst[0] + " | pos = " + rst[2] + " | neg = " + rst[4] + "\nThe rule doesn't cover: " + rst[1] + " | pos = " + rst[5]);
            }
            if (!(stop = this.checkStop(rst, minDL, dl))) {
                ruleset.addElement(oneRule);
                newData = rstats.getFiltered(last)[1];
                hasPositive = Utils.gr(rst[5], 0.0);
                if (!this.m_Debug) continue;
                System.err.println("One rule added: has positive? " + hasPositive);
                continue;
            }
            if (this.m_Debug) {
                System.err.println("Quit rule");
            }
            rstats.removeLast();
        }
        RuleStats finalRulesetStat = null;
        if (this.m_UsePruning) {
            int z = 0;
            while (z < this.m_Optimizations) {
                if (this.m_Debug) {
                    System.err.println("\n*** Optimization: run #" + z + " ***");
                }
                newData = data;
                finalRulesetStat = new RuleStats();
                finalRulesetStat.setData(newData);
                finalRulesetStat.setNumAllConds(this.m_Total);
                int position = 0;
                stop = false;
                boolean isResidual = false;
                hasPositive = defHasPositive;
                dl = minDL = defDL;
                while (!stop && hasPositive) {
                    RipperRule finalRule;
                    isResidual = position >= ruleset.size();
                    newData = RuleStats.stratify(newData, this.m_Folds, this.m_Random);
                    Instances[] part = RuleStats.partition(newData, this.m_Folds);
                    growData = part[0];
                    pruneData = part[1];
                    if (this.m_Debug) {
                        System.err.println("\nRule #" + position + "| isResidual?" + isResidual + "| data size: " + newData.sumOfWeights());
                    }
                    if (isResidual) {
                        RipperRule newRule = new RipperRule();
                        newRule.setConsequent(classIndex);
                        if (this.m_Debug) {
                            System.err.println("\nGrowing and pruning a new rule ...");
                        }
                        newRule.grow(growData);
                        newRule.prune(pruneData, false);
                        finalRule = newRule;
                        if (this.m_Debug) {
                            System.err.println("\nNew rule found: " + newRule.toString(this.m_Class));
                        }
                    } else {
                        RipperRule oldRule = (RipperRule)ruleset.elementAt(position);
                        boolean covers = false;
                        int i = 0;
                        while (i < newData.numInstances()) {
                            if (oldRule.covers(newData.instance(i))) {
                                covers = true;
                                break;
                            }
                            ++i;
                        }
                        if (!covers) {
                            finalRulesetStat.addAndUpdate(oldRule);
                            ++position;
                            continue;
                        }
                        if (this.m_Debug) {
                            System.err.println("\nGrowing and pruning Replace ...");
                        }
                        RipperRule replace = new RipperRule();
                        replace.setConsequent(classIndex);
                        replace.grow(growData);
                        pruneData = RuleStats.rmCoveredBySuccessives(pruneData, ruleset, position);
                        replace.prune(pruneData, true);
                        if (this.m_Debug) {
                            System.err.println("\nGrowing and pruning Revision ...");
                        }
                        RipperRule revision = (RipperRule)oldRule.copy();
                        Instances newGrowData = new Instances(growData, 0);
                        int b = 0;
                        while (b < growData.numInstances()) {
                            Instance inst = growData.instance(b);
                            if (revision.covers(inst)) {
                                newGrowData.add(inst);
                            }
                            ++b;
                        }
                        revision.grow(newGrowData);
                        revision.prune(pruneData, true);
                        double[][] prevRuleStats = new double[position][6];
                        int c = 0;
                        while (c < position) {
                            prevRuleStats[c] = finalRulesetStat.getSimpleStats(c);
                            ++c;
                        }
                        FastVector tempRules = (FastVector)ruleset.copyElements();
                        tempRules.setElementAt(replace, position);
                        RuleStats repStat = new RuleStats(data, tempRules);
                        repStat.setNumAllConds(this.m_Total);
                        repStat.countData(position, newData, prevRuleStats);
                        rst = repStat.getSimpleStats(position);
                        if (this.m_Debug) {
                            System.err.println("Replace rule covers: " + rst[0] + " | pos = " + rst[2] + " | neg = " + rst[4] + "\nThe rule doesn't cover: " + rst[1] + " | pos = " + rst[5]);
                        }
                        double repDL = repStat.relativeDL(position, expFPRate, this.m_CheckErr);
                        if (this.m_Debug) {
                            System.err.println("\nReplace: " + replace.toString(this.m_Class) + " |dl = " + repDL);
                        }
                        if (Double.isNaN(repDL) || Double.isInfinite(repDL)) {
                            throw new Exception("Should never happen: repDLin optmz. stage NaN or infinite!");
                        }
                        tempRules.setElementAt(revision, position);
                        RuleStats revStat = new RuleStats(data, tempRules);
                        revStat.setNumAllConds(this.m_Total);
                        revStat.countData(position, newData, prevRuleStats);
                        double revDL = revStat.relativeDL(position, expFPRate, this.m_CheckErr);
                        if (this.m_Debug) {
                            System.err.println("Revision: " + revision.toString(this.m_Class) + " |dl = " + revDL);
                        }
                        if (Double.isNaN(revDL) || Double.isInfinite(revDL)) {
                            throw new Exception("Should never happen: revDLin optmz. stage NaN or infinite!");
                        }
                        rstats = new RuleStats(data, ruleset);
                        rstats.setNumAllConds(this.m_Total);
                        rstats.countData(position, newData, prevRuleStats);
                        double oldDL = rstats.relativeDL(position, expFPRate, this.m_CheckErr);
                        if (Double.isNaN(oldDL) || Double.isInfinite(oldDL)) {
                            throw new Exception("Should never happen: oldDLin optmz. stage NaN or infinite!");
                        }
                        if (this.m_Debug) {
                            System.err.println("Old rule: " + oldRule.toString(this.m_Class) + " |dl = " + oldDL);
                        }
                        if (this.m_Debug) {
                            System.err.println("\nrepDL: " + repDL + "\nrevDL: " + revDL + "\noldDL: " + oldDL);
                        }
                        finalRule = oldDL <= revDL && oldDL <= repDL ? oldRule : (revDL <= repDL ? revision : replace);
                    }
                    finalRulesetStat.addAndUpdate(finalRule);
                    rst = finalRulesetStat.getSimpleStats(position);
                    if (isResidual) {
                        dl += finalRulesetStat.relativeDL(position, expFPRate, this.m_CheckErr);
                        if (this.m_Debug) {
                            System.err.println("After optimization: the dl=" + dl + " | best: " + minDL);
                        }
                        if (dl < minDL) {
                            minDL = dl;
                        }
                        if (!(stop = this.checkStop(rst, minDL, dl))) {
                            ruleset.addElement(finalRule);
                        } else {
                            finalRulesetStat.removeLast();
                            --position;
                        }
                    } else {
                        ruleset.setElementAt(finalRule, position);
                    }
                    if (this.m_Debug) {
                        System.err.println("The rule covers: " + rst[0] + " | pos = " + rst[2] + " | neg = " + rst[4] + "\nThe rule doesn't cover: " + rst[1] + " | pos = " + rst[5]);
                        System.err.println("\nRuleset so far: ");
                        int x = 0;
                        while (x < ruleset.size()) {
                            System.err.println(String.valueOf(x) + ": " + ((RipperRule)ruleset.elementAt(x)).toString(this.m_Class));
                            ++x;
                        }
                        System.err.println();
                    }
                    if (finalRulesetStat.getRulesetSize() > 0) {
                        newData = finalRulesetStat.getFiltered(position)[1];
                    }
                    hasPositive = Utils.gr(rst[5], 0.0);
                    ++position;
                }
                if (ruleset.size() > position + 1) {
                    int k = position + 1;
                    while (k < ruleset.size()) {
                        finalRulesetStat.addAndUpdate((Rule)ruleset.elementAt(k));
                        ++k;
                    }
                }
                if (this.m_Debug) {
                    System.err.println("\nDeleting rules to decrease DL of the whole ruleset ...");
                }
                finalRulesetStat.reduceDL(expFPRate, this.m_CheckErr);
                if (this.m_Debug) {
                    int del = ruleset.size() - finalRulesetStat.getRulesetSize();
                    System.err.println(String.valueOf(del) + " rules are deleted" + " after DL reduction procedure");
                }
                ruleset = finalRulesetStat.getRuleset();
                rstats = finalRulesetStat;
                ++z;
            }
        }
        if (this.m_Debug) {
            System.err.println("\nFinal ruleset: ");
            int x = 0;
            while (x < ruleset.size()) {
                System.err.println(String.valueOf(x) + ": " + ((RipperRule)ruleset.elementAt(x)).toString(this.m_Class));
                ++x;
            }
            System.err.println();
        }
        this.m_Ruleset.appendElements(ruleset);
        this.m_RulesetStats.addElement(rstats);
        if (ruleset.size() > 0) {
            return rstats.getFiltered(ruleset.size() - 1)[1];
        }
        return data;
    }

    private boolean checkStop(double[] rst, double minDL, double dl) {
        if (dl > minDL + MAX_DL_SURPLUS) {
            if (this.m_Debug) {
                System.err.println("DL too large: " + dl + " | " + minDL);
            }
            return true;
        }
        if (!Utils.gr(rst[2], 0.0)) {
            if (this.m_Debug) {
                System.err.println("Too few positives.");
            }
            return true;
        }
        if (rst[4] / rst[0] >= 0.5) {
            if (this.m_CheckErr) {
                if (this.m_Debug) {
                    System.err.println("Error too large: " + rst[4] + "/" + rst[0]);
                }
                return true;
            }
            return false;
        }
        if (this.m_Debug) {
            System.err.println("Continue.");
        }
        return false;
    }

    public String toString() {
        if (this.m_Ruleset == null) {
            return "JRIP: No model built yet.";
        }
        StringBuffer sb = new StringBuffer("JRIP rules:\n===========\n\n");
        int j = 0;
        while (j < this.m_RulesetStats.size()) {
            RuleStats rs = (RuleStats)this.m_RulesetStats.elementAt(j);
            FastVector rules = rs.getRuleset();
            int k = 0;
            while (k < rules.size()) {
                double[] simStats = rs.getSimpleStats(k);
                sb.append(String.valueOf(((RipperRule)rules.elementAt(k)).toString(this.m_Class)) + " (" + simStats[0] + "/" + simStats[4] + ")\n");
                ++k;
            }
            ++j;
        }
        if (this.m_Debug) {
            System.err.println("Inside m_Ruleset");
            int i = 0;
            while (i < this.m_Ruleset.size()) {
                System.err.println(((RipperRule)this.m_Ruleset.elementAt(i)).toString(this.m_Class));
                ++i;
            }
        }
        sb.append("\nNumber of Rules : " + this.m_Ruleset.size() + "\n");
        return sb.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8119 $");
    }

    public static void main(String[] args) {
        JRip.runClassifier(new JRip(), args);
    }

    public abstract class Antd
    implements WeightedInstancesHandler,
    Copyable,
    Serializable,
    RevisionHandler {
        private static final long serialVersionUID = -8929754772994154334L;
        protected Attribute att;
        protected double value;
        protected double maxInfoGain;
        protected double accuRate;
        protected double cover;
        protected double accu;

        public Antd(Attribute a) {
            this.att = a;
            this.value = Double.NaN;
            this.maxInfoGain = 0.0;
            this.accuRate = Double.NaN;
            this.cover = Double.NaN;
            this.accu = Double.NaN;
        }

        public abstract Instances[] splitData(Instances var1, double var2, double var4);

        public abstract boolean covers(Instance var1);

        public abstract String toString();

        @Override
        public abstract Object copy();

        public Attribute getAttr() {
            return this.att;
        }

        public double getAttrValue() {
            return this.value;
        }

        public double getMaxInfoGain() {
            return this.maxInfoGain;
        }

        public double getAccuRate() {
            return this.accuRate;
        }

        public double getAccu() {
            return this.accu;
        }

        public double getCover() {
            return this.cover;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 8119 $");
        }
    }

    public class NominalAntd
    extends Antd {
        static final long serialVersionUID = -9102297038837585135L;
        private double[] accurate;
        private double[] coverage;

        public NominalAntd(Attribute a) {
            super(a);
            int bag = this.att.numValues();
            this.accurate = new double[bag];
            this.coverage = new double[bag];
        }

        @Override
        public Object copy() {
            NominalAntd antec = new NominalAntd(this.getAttr());
            antec.value = this.value;
            return antec;
        }

        @Override
        public Instances[] splitData(Instances data, double defAcRt, double cl) {
            int bag = this.att.numValues();
            Instances[] splitData = new Instances[bag];
            int x = 0;
            while (x < bag) {
                splitData[x] = new Instances(data, data.numInstances());
                this.accurate[x] = 0.0;
                this.coverage[x] = 0.0;
                ++x;
            }
            x = 0;
            while (x < data.numInstances()) {
                Instance inst = data.instance(x);
                if (!inst.isMissing(this.att)) {
                    int v = (int)inst.value(this.att);
                    splitData[v].add(inst);
                    int n = v;
                    this.coverage[n] = this.coverage[n] + inst.weight();
                    if ((int)inst.classValue() == (int)cl) {
                        int n2 = v;
                        this.accurate[n2] = this.accurate[n2] + inst.weight();
                    }
                }
                ++x;
            }
            x = 0;
            while (x < bag) {
                double p = this.accurate[x] + 1.0;
                double t = this.coverage[x] + 1.0;
                double infoGain = this.accurate[x] * (Utils.log2(p / t) - Utils.log2(defAcRt));
                if (infoGain > this.maxInfoGain) {
                    this.maxInfoGain = infoGain;
                    this.cover = this.coverage[x];
                    this.accu = this.accurate[x];
                    this.accuRate = p / t;
                    this.value = x;
                }
                ++x;
            }
            return splitData;
        }

        @Override
        public boolean covers(Instance inst) {
            boolean isCover = false;
            if (!inst.isMissing(this.att) && (int)inst.value(this.att) == (int)this.value) {
                isCover = true;
            }
            return isCover;
        }

        @Override
        public String toString() {
            return String.valueOf(this.att.name()) + " = " + this.att.value((int)this.value);
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 8119 $");
        }
    }

    public class NumericAntd
    extends Antd {
        static final long serialVersionUID = 5699457269983735442L;
        private double splitPoint;

        public NumericAntd(Attribute a) {
            super(a);
            this.splitPoint = Double.NaN;
        }

        public double getSplitPoint() {
            return this.splitPoint;
        }

        @Override
        public Object copy() {
            NumericAntd na = new NumericAntd(this.getAttr());
            na.value = this.value;
            na.splitPoint = this.splitPoint;
            return na;
        }

        @Override
        public Instances[] splitData(Instances insts, double defAcRt, double cl) {
            Instance inst;
            Instances data = insts;
            int total = data.numInstances();
            int split = 1;
            int prev = 0;
            int finalSplit = split;
            this.maxInfoGain = 0.0;
            this.value = 0.0;
            double fstCover = 0.0;
            double sndCover = 0.0;
            double fstAccu = 0.0;
            double sndAccu = 0.0;
            data.sort(this.att);
            int x = 0;
            while (x < data.numInstances()) {
                inst = data.instance(x);
                if (inst.isMissing(this.att)) {
                    total = x;
                    break;
                }
                sndCover += inst.weight();
                if (Utils.eq(inst.classValue(), cl)) {
                    sndAccu += inst.weight();
                }
                ++x;
            }
            if (total == 0) {
                return null;
            }
            this.splitPoint = data.instance(total - 1).value(this.att);
            while (split <= total) {
                if (split == total || data.instance(split).value(this.att) > data.instance(prev).value(this.att)) {
                    double coverage;
                    double accurate;
                    double accRate;
                    double infoGain;
                    boolean isFirst;
                    double sndInfoGain;
                    int y = prev;
                    while (y < split) {
                        inst = data.instance(y);
                        fstCover += inst.weight();
                        if (Utils.eq(data.instance(y).classValue(), cl)) {
                            fstAccu += inst.weight();
                        }
                        ++y;
                    }
                    double fstAccuRate = (fstAccu + 1.0) / (fstCover + 1.0);
                    double sndAccuRate = (sndAccu + 1.0) / (sndCover + 1.0);
                    double fstInfoGain = fstAccu * (Utils.log2(fstAccuRate) - Utils.log2(defAcRt));
                    if (fstInfoGain > (sndInfoGain = sndAccu * (Utils.log2(sndAccuRate) - Utils.log2(defAcRt)))) {
                        isFirst = true;
                        infoGain = fstInfoGain;
                        accRate = fstAccuRate;
                        accurate = fstAccu;
                        coverage = fstCover;
                    } else {
                        isFirst = false;
                        infoGain = sndInfoGain;
                        accRate = sndAccuRate;
                        accurate = sndAccu;
                        coverage = sndCover;
                    }
                    if (infoGain > this.maxInfoGain) {
                        this.splitPoint = data.instance(prev).value(this.att);
                        this.value = !isFirst ? 1 : 0;
                        this.accuRate = accRate;
                        this.accu = accurate;
                        this.cover = coverage;
                        this.maxInfoGain = infoGain;
                        finalSplit = isFirst ? split : prev;
                    }
                    int y2 = prev;
                    while (y2 < split) {
                        Instance inst2 = data.instance(y2);
                        sndCover -= inst2.weight();
                        if (Utils.eq(data.instance(y2).classValue(), cl)) {
                            sndAccu -= inst2.weight();
                        }
                        ++y2;
                    }
                    prev = split;
                }
                ++split;
            }
            Instances[] splitData = new Instances[]{new Instances(data, 0, finalSplit), new Instances(data, finalSplit, total - finalSplit)};
            return splitData;
        }

        @Override
        public boolean covers(Instance inst) {
            boolean isCover = true;
            if (!inst.isMissing(this.att)) {
                if ((int)this.value == 0) {
                    if (inst.value(this.att) > this.splitPoint) {
                        isCover = false;
                    }
                } else if (inst.value(this.att) < this.splitPoint) {
                    isCover = false;
                }
            } else {
                isCover = false;
            }
            return isCover;
        }

        @Override
        public String toString() {
            String symbol = (int)this.value == 0 ? " <= " : " >= ";
            return String.valueOf(this.att.name()) + symbol + Utils.doubleToString(this.splitPoint, 6);
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 8119 $");
        }
    }

    public class RipperRule
    extends Rule {
        static final long serialVersionUID = -2410020717305262952L;
        private double m_Consequent = -1.0;
        protected FastVector m_Antds = new FastVector();

        public void setConsequent(double cl) {
            this.m_Consequent = cl;
        }

        @Override
        public double getConsequent() {
            return this.m_Consequent;
        }

        @Override
        public Object copy() {
            RipperRule copy = new RipperRule();
            copy.setConsequent(this.getConsequent());
            copy.m_Antds = (FastVector)this.m_Antds.copyElements();
            return copy;
        }

        @Override
        public boolean covers(Instance datum) {
            boolean isCover = true;
            int i = 0;
            while (i < this.m_Antds.size()) {
                Antd antd = (Antd)this.m_Antds.elementAt(i);
                if (!antd.covers(datum)) {
                    isCover = false;
                    break;
                }
                ++i;
            }
            return isCover;
        }

        @Override
        public boolean hasAntds() {
            if (this.m_Antds == null) {
                return false;
            }
            return this.m_Antds.size() > 0;
        }

        public FastVector getAntds() {
            return this.m_Antds;
        }

        @Override
        public double size() {
            return this.m_Antds.size();
        }

        private double computeDefAccu(Instances data) {
            double defAccu = 0.0;
            int i = 0;
            while (i < data.numInstances()) {
                Instance inst = data.instance(i);
                if ((int)inst.classValue() == (int)this.m_Consequent) {
                    defAccu += inst.weight();
                }
                ++i;
            }
            return defAccu;
        }

        @Override
        public void grow(Instances data) throws Exception {
            if (this.m_Consequent == -1.0) {
                throw new Exception(" Consequent not set yet.");
            }
            Instances growData = data;
            double sumOfWeights = growData.sumOfWeights();
            if (!Utils.gr(sumOfWeights, 0.0)) {
                return;
            }
            double defAccu = this.computeDefAccu(growData);
            double defAcRt = (defAccu + 1.0) / (sumOfWeights + 1.0);
            boolean[] used = new boolean[growData.numAttributes()];
            int k = 0;
            while (k < used.length) {
                used[k] = false;
                ++k;
            }
            int numUnused = used.length;
            int j = 0;
            while (j < this.m_Antds.size()) {
                Antd antdj = (Antd)this.m_Antds.elementAt(j);
                if (!antdj.getAttr().isNumeric()) {
                    used[antdj.getAttr().index()] = true;
                    --numUnused;
                }
                ++j;
            }
            while (Utils.gr(growData.numInstances(), 0.0) && numUnused > 0 && Utils.sm(defAcRt, 1.0)) {
                double maxInfoGain = 0.0;
                Antd oneAntd = null;
                Instances coverData = null;
                Enumeration enumAttr = growData.enumerateAttributes();
                while (enumAttr.hasMoreElements()) {
                    Instances coveredData;
                    Attribute att = (Attribute)enumAttr.nextElement();
                    if (JRip.this.m_Debug) {
                        System.err.println("\nOne condition: size = " + growData.sumOfWeights());
                    }
                    Antd antd = null;
                    antd = att.isNumeric() ? new NumericAntd(att) : new NominalAntd(att);
                    if (used[att.index()] || (coveredData = this.computeInfoGain(growData, defAcRt, antd)) == null) continue;
                    double infoGain = antd.getMaxInfoGain();
                    if (JRip.this.m_Debug) {
                        System.err.println("Test of '" + antd.toString() + "': infoGain = " + infoGain + " | Accuracy = " + antd.getAccuRate() + "=" + antd.getAccu() + "/" + antd.getCover() + " def. accuracy: " + defAcRt);
                    }
                    if (!(infoGain > maxInfoGain)) continue;
                    oneAntd = antd;
                    coverData = coveredData;
                    maxInfoGain = infoGain;
                }
                if (oneAntd == null || Utils.sm(oneAntd.getAccu(), JRip.this.m_MinNo)) break;
                if (!oneAntd.getAttr().isNumeric()) {
                    used[oneAntd.getAttr().index()] = true;
                    --numUnused;
                }
                this.m_Antds.addElement(oneAntd);
                growData = coverData;
                defAcRt = oneAntd.getAccuRate();
            }
        }

        private Instances computeInfoGain(Instances instances, double defAcRt, Antd antd) {
            Instances data = instances;
            Instances[] splitData = antd.splitData(data, defAcRt, this.m_Consequent);
            if (splitData != null) {
                return splitData[(int)antd.getAttrValue()];
            }
            return null;
        }

        public void prune(Instances pruneData, boolean useWhole) {
            int size;
            Instances data = pruneData;
            double total = data.sumOfWeights();
            if (!Utils.gr(total, 0.0)) {
                return;
            }
            double defAccu = this.computeDefAccu(data);
            if (JRip.this.m_Debug) {
                System.err.println("Pruning with " + defAccu + " positive data out of " + total + " instances");
            }
            if ((size = this.m_Antds.size()) == 0) {
                return;
            }
            double[] worthRt = new double[size];
            double[] coverage = new double[size];
            double[] worthValue = new double[size];
            int w = 0;
            while (w < size) {
                worthValue[w] = 0.0;
                coverage[w] = 0.0;
                worthRt[w] = 0.0;
                ++w;
            }
            double tn = 0.0;
            int x = 0;
            while (x < size) {
                Antd antd = (Antd)this.m_Antds.elementAt(x);
                Instances newData = data;
                data = new Instances(newData, 0);
                int y = 0;
                while (y < newData.numInstances()) {
                    Instance ins = newData.instance(y);
                    if (antd.covers(ins)) {
                        int n = x;
                        coverage[n] = coverage[n] + ins.weight();
                        data.add(ins);
                        if ((int)ins.classValue() == (int)this.m_Consequent) {
                            int n2 = x;
                            worthValue[n2] = worthValue[n2] + ins.weight();
                        }
                    } else if (useWhole && (int)ins.classValue() != (int)this.m_Consequent) {
                        tn += ins.weight();
                    }
                    ++y;
                }
                if (useWhole) {
                    int n = x;
                    worthValue[n] = worthValue[n] + tn;
                    worthRt[x] = worthValue[x] / total;
                } else {
                    worthRt[x] = (worthValue[x] + 1.0) / (coverage[x] + 2.0);
                }
                ++x;
            }
            double maxValue = (defAccu + 1.0) / (total + 2.0);
            int maxIndex = -1;
            int i = 0;
            while (i < worthValue.length) {
                if (JRip.this.m_Debug) {
                    double denom = useWhole ? total : coverage[i];
                    System.err.println(String.valueOf(i) + "(useAccuray? " + !useWhole + "): " + worthRt[i] + "=" + worthValue[i] + "/" + denom);
                }
                if (worthRt[i] > maxValue) {
                    maxValue = worthRt[i];
                    maxIndex = i;
                }
                ++i;
            }
            int z = size - 1;
            while (z > maxIndex) {
                this.m_Antds.removeElementAt(z);
                --z;
            }
        }

        public String toString(Attribute classAttr) {
            StringBuffer text = new StringBuffer();
            if (this.m_Antds.size() > 0) {
                int j = 0;
                while (j < this.m_Antds.size() - 1) {
                    text.append("(" + ((Antd)this.m_Antds.elementAt(j)).toString() + ") and ");
                    ++j;
                }
                text.append("(" + ((Antd)this.m_Antds.lastElement()).toString() + ")");
            }
            text.append(" => " + classAttr.name() + "=" + classAttr.value((int)this.m_Consequent));
            return text.toString();
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 8119 $");
        }
    }
}

