/*
 * Decompiled with CFR 0.152.
 */
package dmLab.array.loader.fileLoader;

import dmLab.array.Array;
import dmLab.array.functions.DiscFunctions;
import dmLab.array.loader.fileLoader.FileLoader;
import java.io.BufferedReader;

public final class FileLoaderCSV
extends FileLoader {
    public boolean firstLineContainsAttributes;
    public String defaultAttributeName;
    public boolean consequentSeparatorsTreatAsOne;

    @Override
    protected final boolean privateInitializator() {
        this.separator = (char)44;
        this.nullLabels.clear();
        this.nullLabels.add("");
        this.nullLabels.add("?");
        this.nullLabels.add("NaN");
        this.nullLabels.add("NA");
        this.nullLabels.add("Null");
        this.firstLineContainsAttributes = true;
        this.defaultAttributeName = "attr";
        this.trimComments = false;
        this.consequentSeparatorsTreatAsOne = false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean parseInputFile(BufferedReader inputFile) {
        void var3_5;
        int lineCount = 0;
        char[] separators = new char[]{this.separator};
        boolean firstLine = true;
        do {
            String[] list;
            String line;
            try {
                line = inputFile.readLine();
                ++lineCount;
            }
            catch (Exception exception) {
                System.out.println("Error reading input file. Line: " + lineCount);
                return false;
            }
            if (line == null || (line = this.trimComments(line)).length() == 0) continue;
            if (firstLine) {
                list = DiscFunctions.tokenizeString(line, separators, this.consequentSeparatorsTreatAsOne);
                this.attributesNumber = list.length;
                firstLine = false;
                continue;
            }
            list = DiscFunctions.tokenizeString(line, separators, this.consequentSeparatorsTreatAsOne);
            if (this.attributesNumber < list.length) {
                this.attributesNumber = list.length;
            }
            ++this.eventsNumber;
        } while (var3_5 != null);
        System.out.println("Simple Parsing Done!");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean readInputFile(BufferedReader inputFile) {
        void var3_8;
        int lineCount = 0;
        char[] separators = new char[]{this.separator};
        boolean firstLine = true;
        int eventIndex = 0;
        if (!this.firstLineContainsAttributes) {
            int i = 0;
            while (i < this.attributesNumber) {
                this.myArray.attributes[i].name = String.valueOf(this.defaultAttributeName) + i;
                this.myArray.attributes[i].type = 1;
                ++i;
            }
        }
        do {
            String line;
            try {
                line = inputFile.readLine();
                ++lineCount;
            }
            catch (Exception exception) {
                System.err.println("Error reading input file. Line: " + lineCount);
                return false;
            }
            if (line == null || (line = this.trimComments(line)).length() == 0) continue;
            String[] list = DiscFunctions.tokenizeString(line, separators, this.consequentSeparatorsTreatAsOne);
            if (firstLine && this.firstLineContainsAttributes) {
                int i = 0;
                while (i < this.attributesNumber) {
                    String name = i >= list.length ? String.valueOf(this.defaultAttributeName) + i : list[i];
                    if (name.equalsIgnoreCase("")) {
                        name = String.valueOf(this.defaultAttributeName) + i;
                    }
                    this.myArray.attributes[i].name = name.trim().replaceAll(" ", Array.SPACEVALUE);
                    this.myArray.attributes[i].type = 1;
                    ++i;
                }
                firstLine = false;
                continue;
            }
            int listSize = list.length;
            int i = 0;
            while (i < this.attributesNumber) {
                String value;
                if (i >= listSize) {
                    value = this.defaultNullLabel;
                } else {
                    value = list[i];
                    if (this.nullLabels.containsIgnoreCase(value)) {
                        value = this.defaultNullLabel;
                    }
                }
                this.myArray.writeValueStr(i, eventIndex, value);
                ++i;
            }
            ++eventIndex;
        } while (var3_8 != null);
        System.out.println("Reading file is done!");
        return true;
    }
}

