% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_format.R
\name{output_format}
\alias{output_format}
\title{Define an R Markdown output format}
\usage{
output_format(knitr, pandoc, keep_md = FALSE, clean_supporting = TRUE,
  pre_processor = NULL, intermediates_generator = NULL,
  post_processor = NULL, base_format = NULL)
}
\arguments{
\item{knitr}{Knitr options for an output format (see
\code{\link{knitr_options}})}

\item{pandoc}{Pandoc options for an output format (see
\code{\link{pandoc_options}})}

\item{keep_md}{Keep the markdown file generated by knitting. Note that
if this is \code{TRUE} then \code{clean_supporting} will always be
\code{FALSE}.}

\item{clean_supporting}{Cleanup any supporting files after conversion see
\code{\link{render_supporting_files}}}

\item{pre_processor}{An optional pre-processor function that receives the
\code{metadata}, \code{input_file}, \code{runtime}, \code{knit_meta},
\code{files_dir}, and \code{output_dir} and can return additional arguments
to pass to pandoc.}

\item{intermediates_generator}{An optional function that receives the
original \code{input_file}, its \code{encoding}, and the intermediates
directory (i.e. the \code{intermediates_dir} argument to
\code{\link{render}}). The function should generate and return the names of
any intermediate files required to render the \code{input_file}.}

\item{post_processor}{An optional post-processor function that receives the
\code{metadata}, \code{input_file}, \code{output_file}, \code{clean},
and \code{verbose} parmaeters, and can return an alternative
\code{output_file}.}

\item{base_format}{An optional format to extend.}
}
\value{
An R Markdown output format definition that can be passed to
  \code{\link{render}}.
}
\description{
Define an R Markdown output format based on a combination of knitr and pandoc
options.
}
\examples{
\dontrun{
output_format(knitr = knitr_options(opts_chunk = list(dev = 'png')),
              pandoc = pandoc_options(to = "html"))
}

}
\seealso{
\link{render}, \link{knitr_options}, \link{pandoc_options}
}

