% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structured-search.R
\name{mz_structured_search}
\alias{mz_structured_search}
\title{Structured search}
\usage{
mz_structured_search(address = NULL, neighbourhood = NULL, borough = NULL,
  locality = NULL, county = NULL, region = NULL, postalcode = NULL,
  country = NULL, api_key = NULL, ...)
}
\arguments{
\item{address}{Can be a numbered street address or just the name of the street}

\item{neighbourhood}{Neighborhood name (eg "Notting Hill" in London)}

\item{borough}{eg "Manhattan"}

\item{locality}{The city (eg "Oakland")}

\item{county}{The county}

\item{region}{States in the case of US/Canada, or state-like
administrative division in other countries}

\item{postalcode}{AKA the zip code. Can not be used alone, must have at least
one other argument}

\item{country}{The country - Can be the full name or the abbreviation from
\code{\link{mz_countries}}}

\item{api_key}{Your Mapzen API key. The default is to look for the value in
the MAPZEN_KEY environment variable.}

\item{...}{Any of the parameters, other than "text", that appear in
\code{\link{mz_search}}, can appear here, for example \code{size},
\code{boundary.country}, etc.}
}
\description{
\code{\link{mz_search}} allows you to search using an unstructured string of
text, but if your address data has more structure (eg separate columns for
address, city, state, zip), then using the structured search service may
provide more precision. For more information, see
\url{https://mapzen.com/documentation/search/structured-geocoding/}. Note that
all of the arguments are optional, but at least one of them must be non-NULL.
Furthermore, \code{postalcode} can not be used by itself.
}
\seealso{
\code{\link{mz_search}}
}
