% Generated by roxygen2 (4.0.2): do not edit by hand
\name{ss.filter}
\alias{ss.filter}
\title{Smoothing Spline Filter.}
\usage{
ss.filter(x, seasonal = FALSE, period = NULL, plot = TRUE, ...)
}
\arguments{
\item{x}{a numeric vector or univariate time series.}

\item{seasonal}{a logical value indicating to estimate the seasonal component. The default is
\code{FALSE}.}

\item{period}{seasonal period. Only valid for \code{seasonal = TRUE}. The default is
\code{FALSE}.}

\item{plot}{a logical value indicating to make the plots. The default is \code{TRUE}.}

\item{...}{optional arguments to \code{\link{smooth.spline}}.}
}
\value{
A matrix containing the following columns:
\item{data }{original data \code{x}.}
\item{trend}{fitted trend.}
\item{season}{seasonal indices if \code{seasonal = TRUE}.}
\item{residual}{irregularity or residuals.}
}
\description{
uses smoothing spline to estimate the trend, and also estimate the seasonal
component if necessary.
}
\details{
For univariate time seties \eqn{x[t]}, the additive seasonal model is assumed
to be \deqn{x[t] = m[t] + S[t] + R[t],} where \eqn{m[t], S[t], R[t]} are trend, seasonal
and irregular components, respectively. The trend \eqn{m[t]} is estimated by cubic (default)
smoothing spline using function \code{\link{smooth.spline}}. The estimated trend is denoted
to be \eqn{mhat[t]}. If seasonal component is present (\code{seasonal = TRUE}), the seasonal
indices \eqn{Shat[t]} can be
estimated by averaging the sequence \eqn{x[t] - mhat[t]} for each of \code{1:period}, defined
as \eqn{Shat[t]}. For
example, the seasonal component in January can be estimated by the average of all of the
observations made in January after removing the trend component.
To ensure the identifiability of
\eqn{m[t]} and \eqn{S[t]}, we have to assume
\deqn{S[i + j*period] = S[i],  \sum S[i] = 0,}
where \eqn{i = 1,...,period; j = floor(n/period)}.
The irregularity or residuals are computed by \eqn{Rhat[t] = x[t] - mhat[t] - Shat[t]}.

For the multiplicative seasonal model \deqn{x[t] = m[t] * S[t] * R[t],} it can be
transformed to an additive seasonal model by taking a logarithm on both sides if
\eqn{x[t] > 0}, i.e., \deqn{log(x[t]) = log(m[t]) + log(S[t]) + log(R[t]),} and then use
the refined moving average filter for the components decomposition as the same
in the additive seasonal model.

Plots of original data v.s fitted data, fitted trend, seasonal indices (if \code{seasonal = TRUE}) and residuals will be drawn if \code{plot = TRUE}.
}
\examples{
## decompose the trend for the first difference of annual global air temperature from 1880-1985
data(globtemp)
decomp1 <- ss.filter(globtemp)

## decompose the trend and seasonality for CO2 data with monthly and additive seasonality
decomp2 <- ss.filter(co2, seasonal = TRUE, period = 12)

## decompose the trend and seasonality for monthly airline passenger numbers from 1949-1960
decomp3 <- ss.filter(AirPassengers, seasonal = TRUE, period = 12)

## simulation data: oracally efficient estimation for AR(p) coefficients
d <- 12
n <- d*100
x <- (1:n)/n
y <- 1 + 2*x + 0.3*x^2 + sin(pi*x/6) + arima.sim(n = n,list(ar = 0.2), sd = 1)
fit <- ss.filter(y, seasonal = TRUE,period = 12, plot = FALSE)
ar(fit[,4], aic = FALSE, order.max = 1)$ar
}
\author{
Debin Qiu
}
\references{
Green, P. J. and Silverman, B. W. (1994) Nonparametric Regression and Generalized
Linear Models: A Roughness Penalty Approach. Chapman and Hall.

Hastie, T. J. and Tibshirani, R. J. (1990) Generalized Additive Models. Chapman and Hall.

J. Fan and Q. Yao, Nonlinear Time Series: Nonparametric and Parametric Methods, first ed.,
Springer, New York, 2003.
}
\seealso{
\code{\link{ma.filter}}
}

