#' Select by name or expression for each member of a list
#' @param .data \code{list}
#' @param ... The members to select
#' @name list.select
#' @export
#' @examples
#' \dontrun{
#' x <- list(p1 = list(type="A",score=list(c1=10,c2=8)),
#'        p2 = list(type="B",score=list(c1=9,c2=9)),
#'        p3 = list(type="B",score=list(c1=9,c2=7)))
#' list.select(x,type)
#' list.select(x,tp=type)
#' list.select(x,type,score)
#' list.select(x,type,score.range=range(unlist(score)))
#' }
list.select <- function(.data,...) {
  args <- as.list(match.call(expand.dots = FALSE))$`...`
  argnames <- names(args)
  if(is.null(argnames))  argnames <- character(length(args))
  indices <- argnames=="" & vapply(args,is.name,logical(1L))
  argnames[indices] <- vapply(args[indices],as.character,character(1L))
  names(args) <- argnames
  items <- lapply(args,list.map.internal,.data=.data,envir=parent.frame())
  do.call(Map,c(function(.,...) list(...),list(.data),items))
}
