% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{selectGenes}
\alias{selectGenes}
\alias{selectGenes.liger}
\alias{selectGenes.Seurat}
\title{Select a subset of informative genes}
\usage{
selectGenes(object, thresh = 0.1, nGenes = NULL, alpha = 0.99, ...)

\method{selectGenes}{liger}(
  object,
  thresh = 0.1,
  nGenes = NULL,
  alpha = 0.99,
  useDatasets = NULL,
  useUnsharedDatasets = NULL,
  unsharedThresh = 0.1,
  combine = c("union", "intersection"),
  chunk = 1000,
  verbose = getOption("ligerVerbose", TRUE),
  var.thresh = thresh,
  alpha.thresh = alpha,
  num.genes = nGenes,
  datasets.use = useDatasets,
  unshared.datasets = useUnsharedDatasets,
  unshared.thresh = unsharedThresh,
  tol = NULL,
  do.plot = NULL,
  cex.use = NULL,
  unshared = NULL,
  ...
)

\method{selectGenes}{Seurat}(
  object,
  thresh = 0.1,
  nGenes = NULL,
  alpha = 0.99,
  useDatasets = NULL,
  layer = "ligerNormData",
  assay = NULL,
  datasetVar = "orig.ident",
  combine = c("union", "intersection"),
  verbose = getOption("ligerVerbose", TRUE),
  ...
)
}
\arguments{
\item{object}{A \linkS4class{liger}, \linkS4class{ligerDataset} or
\code{Seurat} object, with normalized data available (no scale factor
multipled nor log transformed).}

\item{thresh}{Variance threshold used to identify variable genes. Higher
threshold results in fewer selected genes. Liger and Seurat S3 methods accept
a single value or a vector with specific threshold for each dataset in
\code{useDatasets}.* Default \code{0.1}.}

\item{nGenes}{Number of genes to find for each dataset. By setting this,
we optimize the threshold used for each dataset so that we get \code{nGenes}
selected features for each dataset. Accepts single value or a vector for
dataset specific setting matching \code{useDataset}.* Default \code{NULL}
does not optimize.}

\item{alpha}{Alpha threshold. Controls upper bound for expected mean gene
expression. Lower threshold means higher upper bound. Default \code{0.99}.}

\item{...}{Arguments passed to other methods.}

\item{useDatasets}{A character vector of the names, a numeric or logical
vector of the index of the datasets to use for shared variable feature
selection. Default \code{NULL} uses all datasets.}

\item{useUnsharedDatasets}{A character vector of the names, a numeric or
logical vector of the index of the datasets to use for finding unshared
variable features. Default \code{NULL} does not attempt to find unshared
features.}

\item{unsharedThresh}{The same thing as \code{thresh} that is applied to test
unshared features. A single value for all datasets in
\code{useUnsharedDatasets} or a vector for dataset-specific setting.* Default
\code{0.1}.}

\item{combine}{How to combine variable genes selected from all datasets.
Choose from \code{"union"} or \code{"intersection"}. Default \code{"union"}.}

\item{chunk}{Integer. Number of maximum number of cells in each chunk, when
gene selection is applied to any HDF5 based dataset. Default \code{1000}.}

\item{verbose}{Logical. Whether to show information of the progress. Default
\code{getOption("ligerVerbose")} or \code{TRUE} if users have not set.}

\item{var.thresh, alpha.thresh, num.genes, datasets.use, unshared.datasets, unshared.thresh}{\bold{Deprecated}.
These arguments are renamed and will be removed in the future. Please see
function usage for replacement.}

\item{tol, do.plot, cex.use, unshared}{\bold{Deprecated}. Gene variability
metric is now visualized with separated function
\code{\link{plotVarFeatures}}. Users can now set none-NULL
\code{useUnsharedDatasets} to select unshared genes, instead of having to
switch \code{unshared} on.}

\item{layer}{Where the input normalized counts should be from. Default
\code{"ligerNormData"}. For older Seurat, always retrieve from \code{data}
slot.}

\item{assay}{Name of assay to use. Default \code{NULL} uses current active
assay.}

\item{datasetVar}{Metadata variable name that stores the dataset source
annotation. Default \code{"orig.ident"}.}
}
\value{
Updated object
\itemize{
 \item{liger method - Each involved dataset stored in
 \linkS4class{ligerDataset} is updated with its \code{\link{featureMeta}}
 slot and \code{varUnsharedFeatures} slot (if requested with
 \code{useUnsharedDatasets}), while \code{\link{varFeatures}(object)} will be
 updated with the final combined gene set.}
 \item{Seurat method - Final selection will be updated at
 \code{Seurat::VariableFeatures(object)}. Per-dataset information is
 stored in the \code{meta.features} slot of the chosen Assay.}
}
}
\description{
This function identifies highly variable genes from each dataset
and combines these gene sets (either by union or intersection) for use in
downstream analysis. Assuming that gene expression approximately follows a
Poisson distribution, this function identifies genes with gene expression
variance above a given variance threshold (relative to mean gene expression).
Alternatively, we allow selecting a desired number of genes for each dataset
by ranking the relative variance, and then take the combination.
}
\examples{
pbmc <- normalize(pbmc)
# Select basing on thresholding the relative variance
pbmc <- selectGenes(pbmc, thresh = .1)
# Select specified number for each dataset
pbmc <- selectGenes(pbmc, nGenes = c(60, 60))
}
