% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.R
\name{plotGeneHeatmap}
\alias{plotGeneHeatmap}
\alias{plotFactorHeatmap}
\title{Plot Heatmap of Gene Expression or Factor Loading}
\usage{
plotGeneHeatmap(
  object,
  features,
  cellIdx = NULL,
  slot = c("normData", "rawData", "scaleData", "scaleUnsharedData"),
  useCellMeta = NULL,
  cellAnnotation = NULL,
  featureAnnotation = NULL,
  cellSplitBy = NULL,
  featureSplitBy = NULL,
  viridisOption = "C",
  ...
)

plotFactorHeatmap(
  object,
  factors = NULL,
  cellIdx = NULL,
  slot = c("H.norm", "H"),
  useCellMeta = NULL,
  cellAnnotation = NULL,
  factorAnnotation = NULL,
  cellSplitBy = NULL,
  factorSplitBy = NULL,
  trim = c(0, 0.03),
  viridisOption = "D",
  ...
)
}
\arguments{
\item{object}{A \linkS4class{liger} object, with data to be plot available.}

\item{features, factors}{Character vector of genes of interests or numeric
index of factor to be involved. \code{features} is required, while
\code{factors} is by default all the factors (reads object recorded k value
in \code{uns} slot).}

\item{cellIdx}{Valid index to subscribe cells to be included. See
\code{\link{subsetLiger}}. Default \code{NULL} use all cells.}

\item{slot}{Use the chosen matrix for heatmap. For \code{plotGeneHeatmap},
default \code{"normData"}, alternatively \code{"rawData"},
\code{"scaleData"} or \code{"scaleUnsharedData"}. For
\code{plotFactorHeatmap}, default \code{"H.norm"}, alternatively \code{"H"}.}

\item{useCellMeta}{Character vector of available variable names in
\code{cellMeta}, variables will be added as annotation to the heatmap.
Default \code{NULL}.}

\item{cellAnnotation}{data.frame object for using external annotation, with
each column a variable and each row is a cell. Row names of this data.frame
will be used for matching cells involved in heatmap. For cells not found in
this data.frame, \code{NA}s will be added with warning. Default \code{NULL}.}

\item{featureAnnotation, factorAnnotation}{Similar as \code{cellAnnotation},
while each row would be a gene or factor, respectively. Default \code{NULL}.}

\item{cellSplitBy}{Character vector of variable names available in annotation
given by \code{useCellMeta} and \code{cellAnnotation}. This slices the
heatmap by specified variables. Default \code{NULL}.}

\item{featureSplitBy, factorSplitBy}{Similar as \code{cellSplitBy}. Default
\code{NULL}}

\item{viridisOption}{See \code{option} argument of
\code{\link[viridisLite]{viridis}}. Default \code{"C"} (plasma) for
\code{plotGeneHeatmap} and \code{"D"} (viridis) for \code{plotFactorHeatmap}.}

\item{...}{Additional arguments passed to general function
\code{\link{.plotHeatmap}} and \code{\link[ComplexHeatmap]{Heatmap}}.}

\item{trim}{Numeric vector of two numbers. Higher value limits the maximum
value and lower value limits the minimum value. Default \code{c(0, 0.03)}.}
}
\value{
\code{\link[ComplexHeatmap]{HeatmapList-class}} object
}
\description{
Plot Heatmap of Gene Expression or Factor Loading
}
\examples{
\donttest{
plotGeneHeatmap(pbmcPlot, varFeatures(pbmcPlot))
plotGeneHeatmap(pbmcPlot, varFeatures(pbmcPlot),
                useCellMeta = c("leiden_cluster", "dataset"),
                cellSplitBy = "leiden_cluster")

plotFactorHeatmap(pbmcPlot)
plotFactorHeatmap(pbmcPlot, cellIdx = pbmcPlot$leiden_cluster \%in\% 1:3,
                  useCellMeta = c("leiden_cluster", "dataset"),
                  cellSplitBy = "leiden_cluster")
}
}
