% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplotting.R, R/visualization.R
\name{plotDimRed}
\alias{plotDimRed}
\alias{plotClusterDimRed}
\alias{plotDatasetDimRed}
\alias{plotByDatasetAndCluster}
\alias{plotGeneDimRed}
\alias{plotPeakDimRed}
\alias{plotFactorDimRed}
\title{Generate scatter plot(s) using liger object}
\usage{
plotDimRed(
  object,
  colorBy = NULL,
  useDimRed = NULL,
  slot = c("cellMeta", "rawData", "normData", "scaleData", "H.norm", "H", "normPeak",
    "rawPeak"),
  colorByFunc = NULL,
  cellIdx = NULL,
  splitBy = NULL,
  shapeBy = NULL,
  titles = NULL,
  ...
)

plotClusterDimRed(object, useCluster = NULL, useDimRed = NULL, ...)

plotDatasetDimRed(object, useDimRed = NULL, ...)

plotByDatasetAndCluster(
  object,
  useDimRed = NULL,
  useCluster = NULL,
  combinePlots = TRUE,
  ...
)

plotGeneDimRed(
  object,
  features,
  useDimRed = NULL,
  log = TRUE,
  scaleFactor = 10000,
  zeroAsNA = TRUE,
  colorPalette = "C",
  ...
)

plotPeakDimRed(
  object,
  features,
  useDimRed = NULL,
  log = TRUE,
  scaleFactor = 10000,
  zeroAsNA = TRUE,
  colorPalette = "C",
  ...
)

plotFactorDimRed(
  object,
  factors,
  useDimRed = NULL,
  trimHigh = 0.03,
  zeroAsNA = TRUE,
  colorPalette = "D",
  ...
)
}
\arguments{
\item{object}{A \linkS4class{liger} object.}

\item{colorBy}{Available variable name in specified \code{slot} to look for
color annotation information. See details. Default \code{NULL} generates
all-black dots.}

\item{useDimRed}{Name of the variable storing dimensionality reduction result
in the \code{cellMeta(object)}. Default \code{NULL} use default dimRed.}

\item{slot}{Choose the slot to find the \code{colorBy} variable. See details.
Default \code{"cellMeta"}.}

\item{colorByFunc}{Default \code{NULL}. A function object that expects a
vector/factor/data.frame retrieved by \code{colorBy} as the only input, and
returns an object of the same size, so that the all color "aes" are replaced
by this output. Useful when, for example, users need to scale the gene
expression shown on plot.}

\item{cellIdx}{Character, logical or numeric index that can subscribe cells.
Missing or \code{NULL} for all cells.}

\item{splitBy}{Character vector of categorical variable names in
\code{cellMeta} slot. Split all cells by groupings on this/these variable(s)
to produce a scatter plot containing only the cells in each group. Default
\code{NULL}.}

\item{shapeBy}{Available variable name in \code{cellMeta} slot to look for
categorical annotation to be reflected by dot shapes. Default \code{NULL}.}

\item{titles}{Title text. A character scalar or a character vector with as
many elements as multiple plots are supposed to be generated. Default
\code{NULL}.}

\item{...}{More plot setting arguments. See \code{\link{.ggScatter}} and
\code{\link{.ggplotLigerTheme}}.}

\item{useCluster}{Name of variable in \code{cellMeta(object)}. Default
\code{NULL} uses default cluster.}

\item{combinePlots}{Logical, whether to utilize
\code{\link[cowplot]{plot_grid}} to combine multiple plots into one. Default
\code{TRUE} returns combined ggplot. \code{FALSE} returns a list of ggplot.}

\item{features, factors}{Name of genes or index of factors that need to be
visualized.}

\item{log}{Logical. Whether to log transform the normalized expression of
genes. Default \code{TRUE}.}

\item{scaleFactor}{Number to be multiplied with the normalized expression of
genes before log transformation. Default \code{1e4}. \code{NULL} for not
scaling.}

\item{zeroAsNA}{Logical, whether to swap all zero values to \code{NA} so
\code{naColor} will be used to represent non-expressing features. Default
\code{TRUE}.}

\item{colorPalette}{Name of viridis palette. See
\code{\link[viridisLite]{viridis}} for options. Default \code{"C"} ("plasma")
for gene expression and \code{"D"} ("viridis") for factor loading.}

\item{trimHigh}{Number for highest cut-off to limit the outliers. Factor
loading above this value will all be trimmed to this value. Default
\code{0.03}.}
}
\value{
A ggplot object when a single plot is intended. A list of ggplot
objects, when multiple \code{colorBy} variables and/or \code{splitBy} are
set. When \code{plotly = TRUE}, all ggplot objects become plotly (htmlwidget)
objects.

ggplot object when only one feature (e.g. cluster variable, gene,
factor) is set. List object when multiple of those are specified.
}
\description{
This function allows for using available cell metadata to build
the x-/y-axis. Available per-cell data can be used to form the color/shape
annotation, including cell metadata, raw or processed gene expression, and
unnormalized or aligned factor loading. Multiple coloring variable is allowed
from the same specification of \code{slot}, and this returns a list of plots
with different coloring values. Users can further split the plot(s) by
grouping on cells (e.g. datasets).

some text
}
\details{
Available option for \code{slot} include: \code{"cellMeta"},
\code{"rawData"}, \code{"normData"}, \code{"scaleData"}, \code{"H.norm"}
and \code{"H"}. When \code{"rawData"}, \code{"normData"} or
\code{"scaleData"}, \code{colorBy} has to be a character vector of feature
names. When \code{"H.norm"} or \code{"H"}, \code{colorBy} can be any valid
index to select one factor of interests. Note that character index follows
\code{"Factor_[k]"} format, with replacing \code{[k]} with an integer.

When \code{"cellMeta"}, \code{colorBy} has to be an available column name in
the table. Note that, for \code{colorBy} as well as \code{x}, \code{y},
\code{shapeBy} and \code{splitBy}, since a matrix object is feasible in
\code{cellMeta} table, using a column (e.g. named as \code{"column1"} in a
certain matrix (e.g. named as \code{"matrixVar"}) should follow the syntax of
\code{"matrixVar.column1"}. When the matrix does not have a "colname"
attribute, the subscription goes with \code{"matrixVar.V1"},
\code{"matrixVar.V2"} and etc. Use \code{"UMAP.1"}, \code{"UMAP.2"},
\code{"TSNE.1"} or \code{"TSNE.2"} for the 2D embeddings generated with
rliger package. These are based on the nature of \code{as.data.frame} method
on a \code{\link[S4Vectors]{DataFrame}} object.
}
\examples{
plotDimRed(pbmcPlot, colorBy = "dataset", slot = "cellMeta",
           labelText = FALSE)
plotDimRed(pbmcPlot, colorBy = "S100A8", slot = "normData",
           dotOrder = "ascending", dotSize = 2)
plotDimRed(pbmcPlot, colorBy = 2, slot = "H.norm",
           dotOrder = "ascending", dotSize = 2, colorPalette = "viridis")
plotClusterDimRed(pbmcPlot)
plotDatasetDimRed(pbmcPlot)
plotByDatasetAndCluster(pbmcPlot)
plotGeneDimRed(pbmcPlot, varFeatures(pbmcPlot)[1])
plotFactorDimRed(pbmcPlot, 2)
}
\seealso{
Please refer to \code{\link{plotDimRed}},
\code{\link{.ggScatter}}, \code{\link{.ggplotLigerTheme}} for additional
graphic setting
}
