% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATAC.R
\name{exportInteractTrack}
\alias{exportInteractTrack}
\title{Export predicted gene-pair interaction}
\usage{
exportInteractTrack(
  corrMat,
  pathToCoords,
  useGenes = NULL,
  outputPath = getwd()
)
}
\arguments{
\item{corrMat}{A sparse matrix of correlation with peak names as rows and
gene names as columns.}

\item{pathToCoords}{Path to the gene coordinates file.}

\item{useGenes}{Character vector of gene names to be exported. Default
\code{NULL} uses all genes available in \code{corrMat}.}

\item{outputPath}{Path of filename where the output file will be stored. If
a folder, a file named \code{"Interact_Track.bed"} will be created. Default
current working directory.}
}
\value{
No return value. A file located at \code{outputPath} will be created.
}
\description{
Export the predicted gene-pair interactions calculated by
upstream function \code{\link{linkGenesAndPeaks}} into an Interact Track file
which is compatible with \href{https://genome.ucsc.edu/cgi-bin/hgCustom}{UCSC
Genome Browser}.
}
\examples{
\donttest{
bmmc <- normalize(bmmc)
bmmc <- selectGenes(bmmc)
bmmc <- scaleNotCenter(bmmc)
if (requireNamespace("RcppPlanc", quietly = TRUE) &&
    requireNamespace("GenomicRanges", quietly = TRUE) &&
    requireNamespace("IRanges", quietly = TRUE) &&
    requireNamespace("psych", quietly = TRUE)) {
    bmmc <- runINMF(bmmc)
    bmmc <- quantileNorm(bmmc)
    bmmc <- normalizePeak(bmmc)
    bmmc <- imputeKNN(bmmc, reference = "atac", queries = "rna")
    corr <- linkGenesAndPeaks(
        bmmc, useDataset = "rna",
        pathToCoords = system.file("extdata/hg19_genes.bed", package = "rliger")
    )
    resultPath <- tempfile()
    exportInteractTrack(
        corrMat = corr,
        pathToCoords = system.file("extdata/hg19_genes.bed", package = "rliger"),
        outputPath = resultPath
    )
    head(read.table(resultPath, skip = 1))
}
}
}
