% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{quantile_norm-deprecated}
\alias{quantile_norm-deprecated}
\title{[Deprecated] Quantile align (normalize) factor loading}
\arguments{
\item{object}{\code{liger} object. Should run optimizeALS before calling.}

\item{knn_k}{Number of nearest neighbors for within-dataset knn graph
(default 20).}

\item{ref_dataset}{Name of dataset to use as a "reference" for normalization.
By default, the dataset with the largest number of cells is used.}

\item{min_cells}{Minimum number of cells to consider a cluster shared across
datasets (default 20)}

\item{quantiles}{Number of quantiles to use for quantile normalization
(default 50).}

\item{eps}{The error bound of the nearest neighbor search. (default 0.9)
Lower values give more accurate nearest neighbor graphs but take much longer
to computer.}

\item{dims.use}{Indices of factors to use for shared nearest factor
determination (default 1:ncol(H[[1]])).}

\item{do.center}{Centers the data when scaling factors (useful for less
sparse modalities like methylation data). (default FALSE)}

\item{max_sample}{Maximum number of cells used for quantile normalization of
each cluster and factor. (default 1000)}

\item{refine.knn}{whether to increase robustness of cluster assignments using
KNN graph.(default TRUE)}

\item{rand.seed}{Random seed to allow reproducible results (default 1)}
}
\value{
\code{liger} object with 'H.norm' and 'clusters' slot set.
}
\description{
\bold{Please turn to \code{\link{quantileNorm}}.}

This process builds a shared factor neighborhood graph to jointly cluster
cells, then quantile normalizes corresponding clusters.

The first step, building the shared factor neighborhood graph, is performed
in SNF(), and produces a graph representation where edge weights between
cells (across all datasets) correspond to their similarity in the shared
factor neighborhood space. An important parameter here is knn_k, the number
of neighbors used to build the shared factor space.

Next we perform quantile alignment for each dataset, factor, and cluster (by
stretching/compressing datasets' quantiles to better match those of the
reference dataset). These aligned factor loadings are combined into a single
matrix and returned as H.norm.
}
\seealso{
\code{\link{rliger-deprecated}}
}
