% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotVolcano}
\alias{plotVolcano}
\alias{plotEnhancedVolcano}
\title{Create volcano plot for Wilcoxon test result}
\usage{
plotVolcano(
  result,
  group,
  logFCThresh = 1,
  padjThresh = 0.01,
  labelTopN = 20,
  dotSize = 2,
  dotAlpha = 0.8,
  legendPosition = "top",
  labelSize = 4,
  ...
)

plotEnhancedVolcano(result, group, ...)
}
\arguments{
\item{result}{Data frame table returned by \code{\link{runWilcoxon}}}

\item{group}{Selection of one group available from \code{result$group}}

\item{logFCThresh}{Number for the threshold on the absolute value of the log2
fold change statistics. Default \code{1}.}

\item{padjThresh}{Number for the threshold on the adjusted p-value
statistics. Default \code{0.01}.}

\item{labelTopN}{Number of top differential expressed features to be labeled
on the top of the dots. Default \code{20}.}

\item{dotSize, dotAlpha}{Numbers for universal aesthetics control of dots.
Default \code{2} and \code{0.8}.}

\item{legendPosition}{Text indicating where to place the legend. Choose from
\code{"top"}, \code{"bottom"}, \code{"left"} or \code{"right"}. Default
\code{"top"}.}

\item{labelSize}{Size of labeled top features and line annotations. Default
\code{4}.}

\item{...}{For \code{plotVolcano}, more theme setting arguments passed to
\code{\link{.ggplotLigerTheme}}. For \code{plotEnhancedVolcano}, arguments
passed to \code{\link[EnhancedVolcano]{EnhancedVolcano}}.}
}
\value{
ggplot
}
\description{
\code{plotVolcano} is a simple implementation and shares
most of arguments with other rliger plotting functions.
\code{plotEnhancedVolcano} is a wrapper function of
\code{\link[EnhancedVolcano]{EnhancedVolcano}}, which has provides
substantial amount of arguments for graphical control. However, that requires
the installation of package "EnhancedVolcano".
}
\examples{
result <- runMarkerDEG(pbmcPlot)
plotVolcano(result, 1)
}
