% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifecycle-retired.R
\name{type_of}
\alias{type_of}
\title{Base type of an object}
\usage{
type_of(x)
}
\arguments{
\item{x}{An R object.}
}
\description{
\Sexpr[results=rd, stage=render]{rlang:::lifecycle("soft-deprecated")}
\Sexpr[results=rd, stage=render]{rlang:::lifecycle("experimental")}

This is equivalent to \code{\link[base:typeof]{base::typeof()}} with a few differences that
make dispatching easier:
\itemize{
\item The type of one-sided formulas is "quote".
\item The type of character vectors of length 1 is "string".
\item The type of special and builtin functions is "primitive".
}
}
\section{Life cycle}{


\code{type_of()} is an experimental function. Expect API changes.
}

\examples{
type_of(10L)

# Quosures are treated as a new base type but not formulas:
type_of(quo(10L))
type_of(~10L)

# Compare to base::typeof():
typeof(quo(10L))

# Strings are treated as a new base type:
type_of(letters)
type_of(letters[[1]])

# This is a bit inconsistent with the core language tenet that data
# types are vectors. However, treating strings as a different
# scalar type is quite helpful for switching on function inputs
# since so many arguments expect strings:
switch_type("foo", character = abort("vector!"), string = "result")

# Special and builtin primitives are both treated as primitives.
# That's because it is often irrelevant which type of primitive an
# input is:
typeof(list)
typeof(`$`)
type_of(list)
type_of(`$`)
}
\keyword{internal}
